package com.small_it_office.flatserve.validator.rule;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

import com.small_it_office.flatserve.core.UnexpectedException;
import com.small_it_office.flatserve.validator.MessageResource;
import com.small_it_office.flatserve.validator.internal.ValidatorConstants;

/**
 * of[V[̊NXłB
 * ̃NXpof[V[ł́AAme[Vmessagevf
 * G[bZ[W𐶐܂B
 * Ame[VmessagevfȂꍇAG[bZ[W͋󕶎ƂȂ܂B
 * @param <T> of[V[܂̓tB[hɓKp邽߂̃Ame[V̌^B
 */
public abstract class MessageProcessValidationRule<T extends Annotation> implements ValidationRule<T> {

	/**
	 * {@inheritDoc}
	 */
	public String getMessage(Object rawValue, T annotation, MessageResource messageResource) {
		String messageSource = "";
		Map<String, Object> replaceValueMap = new HashMap<String, Object>();
		Method[] elements = annotation.getClass().getMethods();
		for (Method element : elements) {
			if (element.getReturnType() != void.class && element.getParameterTypes().length == 0
			        && !Modifier.isStatic(element.getModifiers())) {
				String elementName = element.getName();
				Object elementValue = getElementValue(annotation, element);
				if ("message".equals(elementName) && element.getReturnType() == String.class) {
					messageSource = (String)elementValue;
				} else {
					replaceValueMap.put(elementName, elementValue);
				}
			}
		}
		replaceValueMap.put(ValidatorConstants.MESSAGE_PLACEHOLDER_ERRORVALUE, rawValue);
		return messageResource.getMessage(messageSource, replaceValueMap);
	}

	/**
	 * Ame[V̗vf̒l擾܂B
	 * @param annotation Ame[V
	 * @param element vf\MethosIuWFNgB
	 * @return vf̒lB
	 */
	private Object getElementValue(T annotation, Method element) {
		Object elementValue;
		try {
			elementValue = element.invoke(annotation);
		} catch (Exception e) {
			throw new UnexpectedException(e);
		}
		return elementValue;
	}

}
