package com.small_it_office.flatserve.validator.rule.internal;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;

import com.small_it_office.flatserve.validator.internal.util.TypeConvertUtil;
import com.small_it_office.flatserve.validator.rule.DecimalMax;
import com.small_it_office.flatserve.validator.rule.MessageProcessValidationRule;
import com.small_it_office.flatserve.validator.rule.ValidationRuleException;
import com.small_it_office.shared.meslog.message.Message;

/**
 * lw肳ꂽl𒴂ȂƂ؂of[V[NXłB
 */
public class DecimalMaxRule extends MessageProcessValidationRule<DecimalMax> {

	/**
	 * {@inheritDoc}
	 */
	public boolean isValid(Object value, Object rawValue, DecimalMax annotation) {
		if (rawValue == null || "".equals(rawValue)) {
			return true;
		}

		BigDecimal bValue = TypeConvertUtil.bigDecimalValueOf(value);
		if (bValue == null) {
			return false;
		}

		String strMax = annotation.value();
		boolean allowEquiv = annotation.allowEquiv();

		BigDecimal max;
		try {
			max = new BigDecimal(strMax);
		} catch (NumberFormatException e) {
			throw new ValidationRuleException(Message.get("FSVLD-ERR006", ruleName(annotation), strMax), e);
		}

		return (bValue.compareTo(max) == -1) || (allowEquiv && bValue.compareTo(max) == 0);
	}

	/**
	 * Oo͗pɃ[Ԃ܂B
	 * @param annotation of[V[Ame[V
	 * @return [
	 */
	private String ruleName(Annotation annotation) {
		return annotation.annotationType().getSimpleName();
	}

}
