package com.small_it_office.flatserve.validator.rule.internal;

import com.small_it_office.flatserve.validator.rule.Length;
import com.small_it_office.flatserve.validator.rule.MessageProcessValidationRule;
import com.small_it_office.flatserve.validator.rule.ValidationRuleException;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;


/**
 * ܂̓oCgz̒w肳ꂽ͈͓ł邱Ƃ؂of[V[NXłB
 */
public class LengthRule extends MessageProcessValidationRule<Length> {

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 */
	public boolean isValid(Object value, Object rawValue, Length lengthAnnotation) {
		int min = lengthAnnotation.min();
		int max = lengthAnnotation.max();
		if (min < 0 || max < 0) {
			throw new ValidationRuleException(Message.get("FSVLD-ERR011"));
		}

		if (rawValue == null || "".equals(rawValue)) {
			return true;
		}

		int length;
		if (rawValue instanceof String) {
			length = rawValue.toString().length();
		} else {
			logger.warn("FSVLD-LOGW003", Length.class.getSimpleName());
			return false;
		}

		return length >= min && length <= max;
	}

}
