package com.small_it_office.flatserve.core.process.internal;

import java.lang.reflect.Method;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.small_it_office.flatserve.core.response.ByteArrayResponse;
import com.small_it_office.flatserve.core.service.HttpMethod;
import com.small_it_office.flatserve.core.service.HttpService;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * HTTPT[rX\bhHTTP\bh`FbNsNXB
 * ΏۂHTTPT[rX\bhANGXgHTTP\bhiPOSTAGETȂǁjT|[gĂȂꍇ
 * G[Ԃ܂B
 */
public class HttpMethodChecker {

	/**
	 * Logger̃CX^XB
	 */
	private static Logger logger = LoggerFactory.getInstance().getLogger(MethodExistChecker.class);

	/**
	 * RXgN^B
	 */
	private HttpMethodChecker() {
	}

	/**
	 * HTTPT[rX\bh݂̃NGXgHTTP\bhT|[gĂȂ΃G[̃IuWFNgԂ܂B
	 * @param serviceClass HTTPT[rXNXB
	 * @param method HTTPT[rX\bhB
	 * @return T|[gĂnullAT|[gĂȂ΃G[IuWFNgB
	 */
	public static Object check(Class<?> serviceClass, Method method) {
		HttpServletRequest request = RequestContext.get().getHttpServletRequest();
		String httpMethod = request.getMethod();

		if (isHttpMethodSupported(method, httpMethod)) {
			return null;
		}

		logger.info("FSCORE-LOGI012", serviceClass.getName(), method.getName(), httpMethod);

		ByteArrayResponse errorResponse = new ByteArrayResponse();
		errorResponse.setContentType(null);

		String protocol = request.getProtocol();
		if (protocol.endsWith("1.0")) {
			errorResponse.setStatusCode(HttpServletResponse.SC_BAD_REQUEST);
		} else {
			errorResponse.setStatusCode(HttpServletResponse.SC_METHOD_NOT_ALLOWED);
		}
		return errorResponse;
	}

	/**
	 * HTTPT[rX\bhAw肵HTTP\bhł̎sT|[gĂ邩Ԃ܂B
	 * @param serviceMethod HTTPT[rX\bhB
	 * @param httpMethod GETAPOSTȂǂHTTP\bhB
	 * @return T|[gĂtrueB
	 */
	private static boolean isHttpMethodSupported(Method serviceMethod, String httpMethod) {
		HttpService service = serviceMethod.getAnnotation(HttpService.class);
		HttpMethod[] supportedMethods = service.method();
		for (HttpMethod supportedMethod : supportedMethods) {
			if (supportedMethod.matchesName(httpMethod)) {
				return true;
			}
		}
		return false;
	}

}
