package com.small_it_office.flatserve.core.process.internal;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginLoader;
import com.small_it_office.flatserve.core.request.internal.ParameterHolder;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMapper;
import com.small_it_office.flatserve.core.request.internal.RequestParameterReader;
import com.small_it_office.flatserve.core.response.internal.ResponseSender;
import com.small_it_office.flatserve.core.service.internal.HttpServiceExecutor;
import com.small_it_office.flatserve.core.service.internal.HttpServiceFactory;
import com.small_it_office.flatserve.core.service.internal.HttpServiceResolver;

/**
 * NGXg𐧌䂷NXłB
 */
public class HttpServiceProcessor {

	/**
	 * RequestParameterReader̃CX^XB
	 */
	private RequestParameterReader requestReader;

	/**
	 * RequestParameterMapper̃CX^XB
	 */
	private RequestParameterMapper requestMapper;

	/**
	 * ResponseSender̃CX^XB
	 */
	private ResponseSender responseSender;

	/**
	 * HttpServiceFactorỹCX^XB
	 */
	private HttpServiceFactory serviceFactory;

	/**
	 * HttpServiceExecutor̃CX^XB
	 */
	private HttpServiceExecutor serviceExecutor;

	/**
	 * ݒIuWFNgB
	 */
	private Config config;

	/**
	 * RXgN^B
	 * @param config ݒ
	 * @param servletConfig ServletConfigIuWFNgB
	 */
	public HttpServiceProcessor(Config config, ServletConfig servletConfig) {
		this.config = config;

		PluginLoader pluginLoader = new PluginLoader(config, servletConfig);
		requestReader = pluginLoader.load(RequestParameterReader.class);
		requestMapper = pluginLoader.load(RequestParameterMapper.class);
		responseSender = pluginLoader.load(ResponseSender.class);
		serviceFactory = pluginLoader.load(HttpServiceFactory.class);
		serviceExecutor = pluginLoader.load(HttpServiceExecutor.class);
	}

	/**
	 * NGXg̎又s܂B
	 * @throws IOException o͗O
	 */
	public void process() throws IOException {
		RequestContext context = RequestContext.get();
		HttpServletRequest request = context.getHttpServletRequest();

		request.setCharacterEncoding(config.getRequestEncoding());


		HttpServiceResolver resolver = new HttpServiceResolver(config);
		resolver.resolveURI(request.getRequestURI(), request.getContextPath());

		Class<?> serviceClass = resolver.getServiceClass();
		Method method = resolver.getServiceMethod();

		Object responseObject;

		responseObject = MethodExistChecker.check(method, config);

		if (responseObject == null) {
			responseObject = HttpMethodChecker.check(serviceClass, method);
		}

		if (responseObject == null) {
			responseObject = SessionChecker.checkSession(method, config);
		}

		if (responseObject == null) {
			responseObject = executeServiceMethod(serviceClass, method);
		}

		if (responseObject != null) {
			responseSender.process(responseObject);
		}
	}

	/**
	 * HTTPT[rX\bḧ𐶐A\bhs܂B
	 * @param serviceClass HTTPT[rXNXB
	 * @param method HTTPT[rX\bhB
	 * @return IuWFNgB
	 */
	private Object executeServiceMethod(Class<?> serviceClass, Method method) {
		RequestContext context = RequestContext.get();

		Object responseObject;
		Map<String, Object> requestParams = requestReader.process(serviceClass, method, new HashMap<String, Object>(),
		        false, false);
		context.setRequestParams(requestParams);

		ParameterHolder paramHolder = requestMapper.process(serviceClass, method,
		        new ParameterHolder(method.getParameterTypes().length));

		Object[] params = paramHolder.getParams();
		context.setParams(params);
		context.setRawParams(paramHolder.getRawParams());
		Object service = serviceFactory.create(serviceClass, method);

		responseObject = serviceExecutor.execute(method, params, service);
		return responseObject;
	}

}
