package com.small_it_office.flatserve.core.process.internal;

import java.lang.reflect.Method;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.small_it_office.flatserve.core.ErrorResponder;
import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.response.ByteArrayResponse;
import com.small_it_office.flatserve.core.response.ForwardResponse;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * HTTPT[rX\bh݂邩ǂmFA݂Ȃ΃G[𐶐NXB
 */
public class MethodExistChecker {

	/**
	 * Logger̃CX^XB
	 */
	private static Logger logger = LoggerFactory.getInstance().getLogger(MethodExistChecker.class);

	/**
	 * RXgN^B
	 */
	private MethodExistChecker() {
	}

	/**
	 * \bh݂邩ǂmFA݂Ȃ΃G[̃IuWFNgԂ܂B
	 * @param method HTTPT[rX\bhB
	 * @param config ݒIuWFNgB
	 * @return methodnullȂG[IuWFNgBmethodnullłȂnullԂ܂B
	 */
	public static Object check(Method method, Config config) {
		if (method != null) {
			return null;
		}

		RequestContext context = RequestContext.get();
		HttpServletRequest request = context.getHttpServletRequest();

		logger.info("FSCORE-LOGI005", request.getRequestURI());
		HttpServletResponse response = context.getHttpServletResponse();
		response.setStatus(HttpServletResponse.SC_NOT_FOUND);

		ErrorResponder errorResponder = config.getServiceNotFoundErrorResponder();
		String forwardUrl = config.getServiceNotFoundForwardUrl();

		Object errorResponse;
		if (errorResponder != null) {
			errorResponse = errorResponder.respondError(request, response, context.getServletConfig());
		} else if (forwardUrl != null) {
			errorResponse = new ForwardResponse(forwardUrl);
		} else {
			ByteArrayResponse r = new ByteArrayResponse();
			r.setContentType(null);
			errorResponse = r;
		}

		return errorResponse;
	}
}
