package com.small_it_office.flatserve.core.process.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Date;

import javax.servlet.http.HttpServletResponse;

import com.small_it_office.flatserve.core.ApplicationException;
import com.small_it_office.flatserve.core.ErrorResponder;
import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.response.ForwardResponse;
import com.small_it_office.flatserve.core.service.SessionRequired;
import com.small_it_office.flatserve.core.util.internal.AnnotationUtil;
import com.small_it_office.flatserve.core.util.internal.StringUtil;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;

/**
 * HTTPT[rX\bh|{@link SessionRequired}Ame[Vw肳ĂꍇɁAHTTPZbV̗L`FbNNXłB
 */
public class SessionChecker {

	/**
	 * Logger̃CX^XB
	 */
	private static Logger logger = LoggerFactory.getInstance().getLogger(MethodExistChecker.class);

	/**
	 * RXgN^B
	 */
	private SessionChecker() {
	}

	/**
	 * \bhsł𖞂Ă邩AZbV`FbN܂B
	 * \bhSessionRequiredAme[V݂ALȃZbV݂Ȃꍇ́AG[𐶐ĕԂ܂B
	 * @param method HTTPT[rX\bhB
	 * @param config ݒIuWFNgB
	 * @return SessionRequiredAme[V݂ALȃZbV݂Ȃꍇ̓G[IuWFNgBȊȌꍇnullB
	 */
	public static Object checkSession(Method method, Config config) {
		Object errorResponse = null;
		RequestContext context = RequestContext.get();
		Annotation[] annotations = method.getAnnotations();
		Annotation annotation = findSessionRequiredAnnotation(annotations);
		if (annotation != null && context.getHttpServletRequest().getSession(false) == null) {
			if (annotation instanceof SessionRequired) {
				SessionRequired sessionRequired = (SessionRequired)annotation;
				Class<? extends ErrorResponder> errorResponder = sessionRequired.errorResponder();
				String forwardPath = sessionRequired.forwardPath();
				if (errorResponder != ErrorResponder.class) {
					ErrorResponder responder;
					try {
						responder = errorResponder.newInstance();
					} catch (Exception e) {
						throw new ApplicationException(Message.get("FSCORE-ERR020", errorResponder.getName()), e);
					}
					logger.info("FSCORE-LOGI015", errorResponder.getName());
					errorResponse = responder.respondError(context.getHttpServletRequest(),
					        context.getHttpServletResponse(), context.getServletConfig());
				} else if (!("".equals(forwardPath))) {
					logger.info("FSCORE-LOGI016", forwardPath);
					errorResponse = new ForwardResponse(forwardPath);
				}
			}
			if (errorResponse == null) {
				if (config.getSessionTimeoutErrorResponder() != null) {
					logger.info("FSCORE-LOGI015", config.getSessionTimeoutErrorResponder().getClass().getName());
					errorResponse = config.getSessionTimeoutErrorResponder().respondError(context.getHttpServletRequest(),
					        context.getHttpServletResponse(), context.getServletConfig());
				} else if (config.getSessionTimeoutForwardUrl() != null) {
					logger.info("FSCORE-LOGI016", config.getSessionTimeoutForwardUrl());
					errorResponse = new ForwardResponse(config.getSessionTimeoutForwardUrl());
				} else {
					logger.info("FSCORE-LOGI017");
					errorResponse = "Session Timeout occurerd.";
				}
			}
		}

		if (errorResponse != null) {
			HttpServletResponse response = context.getHttpServletResponse();
			response.setHeader("Cache-Control", "no-cache");
			response.setHeader("Pragma", "no-cache");
			response.setHeader("Expires", StringUtil.getHTTPDate(new Date()));
		}
		return errorResponse;
	}

	/**
	 * ZbV`FbNs߂̃Ame[VzɊ܂܂邩ǂmF܂B
	 * <p>
	 * ̔zɁAȉ̂ꂩ܂܂΁A̔zvfԂ܂B
	 * </p>
	 * <ul>
	 * <li>SessionRequiredAme[ṼCX^X</li>
	 * <li>^錾Ƀ^Ame[VƂSessionRequiredw肳ꂽAme[ṼCX^X</li>
	 * </ul>
	 * <p>
	 * L̗݂ꍇ́ASessionRequiredAme[ṼCX^XԂ܂B
	 * </p>
	 * @param annotations Ame[V̔z
	 * @return ZbV`FbNs߂̃Ame[Vzɑ݂΂̃Ame[VB݂ȂnullB
	 */
	private static Annotation findSessionRequiredAnnotation(Annotation[] annotations) {
		SessionRequired sessionRequired = AnnotationUtil.findAnnotation(annotations, SessionRequired.class);
		if (sessionRequired != null) {
			return sessionRequired;
		}
		for (Annotation annotation : annotations) {
			SessionRequired metaSessionRequired = annotation.annotationType().getAnnotation(SessionRequired.class);
			if (metaSessionRequired != null) {
				return annotation;
			}
		}
		return null;
	}
}
