package com.small_it_office.flatserve.core.request.type.internal;

import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Map;

import com.small_it_office.flatserve.core.UnexpectedException;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.Header;
import com.small_it_office.flatserve.core.request.Param;
import com.small_it_office.flatserve.core.request.RequestBody;
import com.small_it_office.flatserve.core.request.internal.NullObject;
import com.small_it_office.flatserve.core.request.internal.ParamNameConstants;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;


/**
 * HTTPT[rX\bḧString̏ꍇɃNGXgp[^Ƃ̃}bsOs܂B
 */
public class StringTypeMapping implements TypeMapping {

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 */
	public MappedParameter mapParameter(Annotation[] annotations, Object readParam) {
		logger.debug("FSCORE-LOGD027", "String", this.getClass().getSimpleName());
		if (readParam != null && readParam != NullObject.getInstance()) {
			logger.debug("FSCORE-LOGD028", readParam);
			return null;
		}
		RequestContext context = RequestContext.get();
		Map<String, Object> requestParams = context.getRequestParams();

		String param = null;
		for (Annotation anno : annotations) {
			if (anno.annotationType() == Param.class) {
				String requestParamName = ((Param)anno).value();
				Object objParam = requestParams.get(requestParamName);
				if (objParam == null) {
					logger.debug("FSCORE-LOGD029", requestParamName);
				} else if (objParam instanceof String[] && Array.getLength(objParam) > 0) {
					param = ((String[])objParam)[0];
					logger.debug("FSCORE-LOGD030", requestParamName, param);
				} else {
					logger.debug("FSCORE-LOGW003", requestParamName, objParam);
				}
				MappedParameter mappedParam = new MappedParameter(param, param);
				return mappedParam;
			} else if (anno.annotationType() == RequestBody.class) {
				byte[] requestBody = (byte[])requestParams.get(ParamNameConstants.REQUEST_BODY);
				//ftHg"UTF-8"ݒ肵Ă͂Ȃ̂ŁAnullɂ͂ȂȂ
				String encoding = context.getHttpServletRequest().getCharacterEncoding();
				try {
					param = new String(requestBody, encoding);
				} catch (UnsupportedEncodingException e) {
					//unsupportedȂ̂ł΁Arequest.setCharacterEncoding()_ŗOĂ͂B
					throw new UnexpectedException(e);
				}
				logger.debug("FSCORE-LOGD031", encoding);
				MappedParameter mappedParam = new MappedParameter(param, requestBody);
				return mappedParam;
			} else if (anno.annotationType() == Header.class) {
				String headerName = ((Header)anno).value().toLowerCase();
				param = (String)requestParams.get(ParamNameConstants.REQUEST_HEADER_KEY_PREFIX + headerName);
				if (param == null) {
					logger.debug("FSCORE-LOGD032", headerName);
				} else {
					logger.debug("FSCORE-LOGD033", headerName, param);
				}
				MappedParameter mappedParam = new MappedParameter(param, param);
				return mappedParam;
			}
		}
		logger.debug("FSCORE-LOGD034", "String");
		return null;
	}
}
