package com.small_it_office.flatserve.core.response;

import java.io.IOException;

import javax.servlet.http.HttpServletResponse;

import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;


/**
 * eLXg̉킷NXłB
 * ̃NX̃IuWFNgHTTPT[rX\bh̖߂lƂĕԂƂŁA
 * Conetnt-Type"text/plain"HTTPԂƂł܂B
 */
public class TextResponse extends Response {

	/**
	 * X|X{fBőMeLXgB
	 */
	private String content = "";

	/**
	 * eLXg̃GR[fBOB
	 */
	private String encoding = "UTF-8";

	/**
	 * X|Xcontent-typeB
	 * ftHgtext/plainB
	 */
	private String contentType = "text/plain";

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void writeResponse() throws IOException {
		HttpServletResponse response = RequestContext.get().getHttpServletResponse();
		response.setCharacterEncoding(encoding);
		logger.debug("FSCORE-LOGD061", encoding);

		logger.debug("FSCORE-LOGD063");
		response.getWriter().write(content);
		logger.debug("FSCORE-LOGD064");
	}

	/**
	 * {@inheritDoc}
	 * ftHgł"text/plain"Ԃ܂B
	 */
	protected String getContentType() {
		return contentType;
	}

	/**
	 * eLXg̃GR[fBOԂ܂B
	 * {@link #setEncoding(String)}Ŏw肳Ȃꍇ́AftHglƂ"UTF-8"Ԃ܂B
	 * @return eLXg̃GR[fBO
	 */
	public String getEncoding() {
		return encoding;
	}

	/**
	 * eLXg̃GR[fBOݒ肵܂B
	 * @param encoding eLXg̃GR[fBO
	 */
	public void setEncoding(String encoding) {
		this.encoding = encoding;
	}

	/**
	 * X|X{fBőMeLXgԂ܂B
	 * {@link #setContent(String)}Őݒ肳Ȃꍇ́A󕶎ƂȂ܂B
	 * @return X|X{fBőMeLXg
	 */
	public String getContent() {
		return content;
	}

	/**
	 * X|X{fBőMeLXgݒ肵܂B
	 * @param content X|X{fBőMeLXg
	 * @throws IllegalArgumentException nullw肵ꍇ
	 */
	public void setContent(String content) {
		if (content == null) {
			throw new IllegalArgumentException(Message.get("FSCORE-ERR017", this.getClass().getSimpleName()));
		}
		this.content = content;
	}

	/**
	 * content-typewb_̒lݒ肵܂B
	 * @param contentType content-typewb_̒lB
	 */
	public void setContentType(String contentType) {
		this.contentType = contentType;
	}
}
