package com.small_it_office.flatserve.aop.internal;

import java.lang.reflect.Method;

import org.aopalliance.intercept.MethodInterceptor;

import com.small_it_office.flatserve.core.ApplicationException;
import com.small_it_office.shared.meslog.message.Message;

/**
 * C^[Zv^KpΏۃNXwłAXyNgłB
 * w肳ꂽNX̃\bhsꍇ݂̂̃\bhɑ΂ăC^[Zv^KpꍇɎgp܂B
 */
public class ClassAssignedAspect extends Aspect {

	/**
	 * C^[Zv^KpΏۃNXB
	 */
	private Class<?> targetServiceClass;

	/**
	 * RXgN^B
	 * @param interceptor C^[Zv^
	 * @param targetServiceClass C^[Zv^KpΏۂƂNX
	 */
	public ClassAssignedAspect(MethodInterceptor interceptor, Class<?> targetServiceClass) {
		super(interceptor);
		this.targetServiceClass = targetServiceClass;
	}

	/**
	 * {@inheritDoc}
	 * ̃NXKpΏۃNXłꍇ̂trueԂ܂B
	 */
	public boolean isAssignable(Class<?> serviceClass, Method serviceMethod) {
		return serviceClass == targetServiceClass;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void validate() {
		super.validate();
		if (targetServiceClass == null) {
			throw new ApplicationException(Message.get("FSAOP-ERR004"));
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return "class assignable aspect(" + targetServiceClass.getName() + ")";
	}
}
