package com.small_it_office.flatserve.transition.internal;

import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletResponse;

import com.small_it_office.flatserve.core.ErrorResponder;
import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginPart;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.response.ForwardResponse;
import com.small_it_office.flatserve.core.service.internal.HttpServiceExecutor;
import com.small_it_office.flatserve.transition.TransitionConfig;
import com.small_it_office.flatserve.transition.TransitionException;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;

/**
 * ʑJڃ`FbNɑΉHttpServiceExecutor̎NXłB
 * sȉʑJڂ̏ꍇ́AΏۂHTTPT[rX\bhsA㏈̃tbNs܂B
 * ʑJڂȏꍇ́APɓŕێHttpServiceExecutorIuWFNgɈڏ܂B
 */
public class TransitionCheckHttpServiceExecutor implements HttpServiceExecutor {

	/**
	 * ̃vOCi̗D揇ʁB
	 */
	private static final int PLUGIN_PRIORITY = 64;

	/**
	 * lXgHttpServiceExecutorB
	 */
	private HttpServiceExecutor executor;

	/**
	 * sȉʑJڂꍇɃtH[h̃AhXB
	 */
	private String transitionErrorPath;

	/**
	 * sȉʑJڂꍇ̉𐶐IuWFNgB
	 */
	private ErrorResponder transitionErrorResponder;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 * <p>
	 * ReLXg񂩂ʑJڂ̃`FbNʂ擾AłȂꍇɉʑJڃG[쐬܂B
	 * ʑJڂł΁APɃlXgHttpServiceExecutors܂B
	 * </p>
	 */
	public Object execute(Method method, Object[] params, Object service) {
		if (RequestContext.get().getAttribute(TransitionCheckConstants.CHECK_RESULT_STORE_KEY) == TransitionState.CORRECT) {
			return executor.execute(method, params, service);
		} else {
			logger.info("FSTRC-LOGI006");
			return executeTransitionError();
		}
	}

	/**
	 * sȉʑJڂꍇ̃X|X쐬܂B
	 * @return X|XIuWFNgB
	 */
	private Object executeTransitionError() {

		RequestContext context = RequestContext.get();
		Object result;
//		if (context.getAttribute(TransitionCheckConstants.CHECK_RESULT_STORE_KEY) == TransitionState.WRONG) {
			if (transitionErrorResponder != null) {
				logger.info("FSTRC-LOGI007", transitionErrorResponder.getClass().getName());
				result = transitionErrorResponder.respondError(context.getHttpServletRequest(),
				        context.getHttpServletResponse(), context.getServletConfig());
			} else if (transitionErrorPath != null) {
				logger.info("FSTRC-LOGI004", transitionErrorPath);
				result = new ForwardResponse(transitionErrorPath);
			} else {
				throw new TransitionException(Message.get("FSTRC-ERR002"));
			}
//		} else {
//			if (sessionTimeoutResponder != null) {
//				logger.info("FSTRC-LOGI008", sessionTimeoutResponder.getClass().getName());
//				result = sessionTimeoutResponder.respondError(context.getHttpServletRequest(),
//				        context.getHttpServletResponse(), context.getServletConfig());
//			} else if (sessionTimeoutPath != null) {
//				logger.info("FSTRC-LOGI005", sessionTimeoutPath);
//				result = new ForwardResponse(sessionTimeoutPath);
//			} else {
//				throw new TransitionException(Message.get("FSTRC-ERR004"));
//			}
//		}

		HttpServletResponse response = context.getHttpServletResponse();
		response.setHeader("Cache-Control", "no-cache");
		response.setHeader("Pragma", "no-cache");
		response.setHeader("Expires", getHTTPDate());
		return result;
	}

	/**
	 * X|Xwb_ɐݒ肷邽߂̓t𐶐܂B
	 * @return HTTPtB
	 */
	private String getHTTPDate() {
		SimpleDateFormat formatter = new SimpleDateFormat("E, dd MMM yyyy hh:mm:ss zzz", Locale.US);
		formatter.setTimeZone(java.util.TimeZone.getTimeZone("GMT"));
		return formatter.format(new Date());
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean nest() {
		return true;
	}

	/**
	 * {@inheritDoc}
	 */
	public void init(Config config, ServletConfig servletConfig) {
		TransitionConfig transitionConfig = config.getOptionalConfig(TransitionConfig.class);
		transitionErrorPath = transitionConfig.getTransitionErrorPath();
		transitionErrorResponder = transitionConfig.getTransitionErrorResponder();

	}

	/**
	 * {@inheritDoc}
	 */
	public void setNestedObject(PluginPart o) {
		executor = (HttpServiceExecutor)o;
	}

	/**
	 * {@inheritDoc}
	 */
	public int priority() {
		return PLUGIN_PRIORITY;
	}

}
