package com.small_it_office.flatserve.transition.internal;

import java.lang.reflect.Method;
import java.util.Map;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginPart;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.internal.RequestParameterReader;
import com.small_it_office.flatserve.transition.IllegalTokenException;
import com.small_it_office.flatserve.transition.Token;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;

/**
 * ʑJڃ`FbNɑΉRequestParameterReader̎NXłB
 * ʑJڂ̃`FbNƁAg[N̕ۑsAŕێRequestParameterReaders܂B
 * ʑJڂsȏꍇ́ARequestParameterReaderɂ郊NGXgbZ[W̓ǂݍ݂͒f܂B
 */
public class TransitionCheckRequestParameterReader implements RequestParameterReader {

	/**
	 * ̃vOCi̗D揇ʁB
	 */
	private static final int PLUGIN_PRIORITY = 128;

	/**
	 * ʑJڂ`FbN邽߂TransitionCheckerIuWFNgB
	 */
	private TransitionChecker checker = new TransitionChecker();

	/**
	 * ŕێRequestParameterReaderB
	 */
	private RequestParameterReader nested;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 */
	public Map<String, Object> process(Class<?> serviceClass, Method method, Map<String, Object> readParams,
	        boolean streamRead, boolean paramRead) {
		RequestContext context = RequestContext.get();
		TransitionState checkResult = checker.check(serviceClass, method);
		context.setAttribute(TransitionCheckConstants.CHECK_RESULT_STORE_KEY, checkResult);
		if (checkResult == TransitionState.CORRECT) {
			saveToken(context.getHttpServletRequest(), method);
			logger.debug("FSTRC-LOGD004", nested.getClass().getName());
			Map<String, Object> result = nested.process(serviceClass, method, readParams, streamRead, paramRead);
			return result;
		} else {
			return readParams;
		}
	}

	/**
	 * HTTPT[rX\bh{@link Token}Ame[VꍇA
	 * w肳ꂽg[NHTTPZbVIuWFNgɕۑ܂B
	 * @param request NGXgIuWFNg
	 * @param method HTTPT[rX\bh
	 */
	private void saveToken(HttpServletRequest request, Method method) {
		Token tokenAnnotation = method.getAnnotation(Token.class);
		if (tokenAnnotation != null) {
			String token = tokenAnnotation.value();
			if ("".equals(token)) {
				throw new IllegalTokenException(Message.get("FSTRC-ERR003", method.getDeclaringClass().getName(),
				        method.getName()));
			}
			request.getSession().setAttribute(TransitionCheckConstants.TOKEN_STORE_KEY, token);
			logger.debug("FSTRC-LOGD005", token);
		}
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean nest() {
		return true;
	}

	/**
	 * {@inheritDoc}
	 */
	public void init(Config config, ServletConfig servletConfig) {
	}

	/**
	 * {@inheritDoc}
	 */
	public void setNestedObject(PluginPart o) {
		this.nested = (RequestParameterReader)o;
	}

	/**
	 * {@inheritDoc}
	 */
	public int priority() {
		return PLUGIN_PRIORITY;
	}

}
