package com.small_it_office.flatserve.validator;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.small_it_office.flatserve.validator.internal.ValidatorConstants;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * of[VG[bZ[W\[Xt@Cǂݍ񂾃bZ[WێA
 * G[bZ[W̐sNXłB
 */
public class MessageResource {

	/**
	 * bZ[W̃v[Xz_\K\p^[B
	 */
	private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{[^\\{\\}]*\\}");

	/**
	 * ValidatorvOCftHgŕێ郊\[XohB
	 */
	private ResourceBundle defaultBundle;

	/**
	 * AvP[V̐ݒɂǂݍ܂ĕێĂ郊\[XohB
	 */
	private ResourceBundle bundle;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * RXgN^B
	 * @param validatorConfig ValidatorvOCݒIuWFNg
	 */
	public MessageResource(ValidatorConfig validatorConfig) {
		String bundleName = validatorConfig.getMessageBundleName();
		Locale locale = validatorConfig.getMessageLocale();

		defaultBundle = ResourceBundle.getBundle("flatserve-validation-error-messages", locale);
		if (bundleName != null) {
			try {
				bundle = ResourceBundle.getBundle(bundleName, locale);
			} catch (MissingResourceException e) {
				logger.warn("FSVLD-LOGW002", bundleName);
				bundle = null;
				return;
			}
			logger.debug("FSVLD-LOGD007", bundleName);
		}
	}

	/**
	 * G[bZ[WԂ܂B
	 * @param source v[Xz_uÕG[bZ[WB
	 * @return v[Xz_ũbZ[WB
	 */
	public String getMessage(String source) {
		return getMessage(source, (Map<String, Object>)null);
	}

	/**
	 * v[Xz_ubZ[WԂ܂B
	 * bZ[W{ErrorValue}܂܂ꍇɂ́AerrorValueŎw肵lɒu܂B
	 * @param source v[Xz_uÕG[bZ[WB
	 * @param errorValue of[VG[ƂȂlB
	 * @return v[Xz_ũbZ[WB
	 */
	public String getMessage(String source, Object errorValue) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put(ValidatorConstants.MESSAGE_PLACEHOLDER_ERRORVALUE, errorValue);
		return getMessage(source, map);
	}

	/**
	 * v[Xz_ubZ[WԂ܂B
	 * @param source v[Xz_uÕG[bZ[WB
	 * @param replacementValues v[Xz_u邽߂̖Oƒli[MapB
	 * @return v[Xz_ũbZ[WB
	 */
	public String getMessage(String source, Map<String, Object> replacementValues) {
		if (source == null) {
			return null;
		}
		StringBuilder builder = new StringBuilder(source);
		Matcher matcher = PLACEHOLDER_PATTERN.matcher(source);
		int findIndex = 0;
		while (matcher.find(findIndex)) {
			int matchStart = matcher.start();
			int matchEnd = matcher.end();
			String placeHolder = builder.substring(matcher.start(), matcher.end());
			String key = placeHolder.substring(1, placeHolder.length() - 1);

			Object replacementValue;
			if (replacementValues != null && replacementValues.containsKey(key)) {
				replacementValue = replacementValues.get(key);
			} else {
				replacementValue = getBundleString(key);
				if (replacementValue == null) {
					findIndex = matcher.end();
					continue;
				}
			}
			builder.replace(matchStart, matchEnd, replacementValue == null ? "null" : replacementValue.toString());
			matcher = PLACEHOLDER_PATTERN.matcher(builder.toString());
		}
		return builder.toString();
	}

	/**
	 * \[Xoh烁bZ[Wǂݍ݂܂B
	 * @param key \[Xoh̃L[B
	 * @return \[Xohǂݍ񂾒lB
	 */
	private String getBundleString(String key) {
		String result = null;
		if (bundle != null) {
			try {
				result = bundle.getString(key);
			} catch (MissingResourceException e) {
				logger.debug("FSVLD-LOGD008", key);
			}
		}

		if (result == null) {
			try {
				result = defaultBundle.getString(key);
			} catch (MissingResourceException e) {
				logger.debug("FSVLD-LOGD043", key);
			}
		}

		return result;
	}

}
