package com.small_it_office.flatserve.validator;

import java.util.Map;

import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.Populator;
import com.small_it_office.flatserve.validator.internal.BeanValidator;
import com.small_it_office.flatserve.validator.internal.PopulatorValidationException;
import com.small_it_office.flatserve.validator.internal.ValidatorConstants;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * HTTPNGXgőMꂽi[JavaBeañCX^X𐶐NXłB
 * PopulatorNX̋@\gAof[V̋@\ǉĂ܂B
 */
public class ValidatablePopulator {

	/**
	 * SingletonCX^XB
	 */
	private static ValidatablePopulator instance = new ValidatablePopulator();

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * ̃NX̃CX^X擾܂B
	 * @return ̃NX̃CX^XB
	 */
	public static ValidatablePopulator getInstance() {
		return instance;
	}

	/**
	 * JavaBeañCX^X𐶐ANGXgi[ĕԂ܂B
	 * ɁAof[VsȂ܂B
	 * <p>
	 * of[VG[̏ꍇɂ͗Othrow܂B
	 * ̗ÓAFlatServeɂď̂ŁAAvP[VcatchKv͂܂B
	 * catchꍇ́Aof[VG[\bhs܂B
	 * </p>
	 * @param <T> JavaBeaň^B
	 * @param beanType JavaBeañNXB
	 * @return NGXg񂪊i[ꂽJavaBeañCX^XB
	 */
	public <T> T populate(Class<T> beanType) {

		logger.info("FSVLD-LOGI005");

		T bean = Populator.getInstance().populate(beanType);

		RequestContext context = RequestContext.get();

		Map<String, Object> rawParam = context.getPopulatedBeanRawData();
		BeanValidator.getInstance().validate(bean, rawParam);

		ValidationErrors errors = (ValidationErrors)context.getAttribute(ValidatorConstants.ERRORS_STORE_KEY);
		if (errors.hasError()) {
			throw new PopulatorValidationException(bean);
		}

		logger.info("FSVLD-LOGI006");

		return bean;
	}
}
