package com.small_it_office.flatserve.validator.converter.internal;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;

import com.small_it_office.flatserve.core.util.internal.AnnotationUtil;
import com.small_it_office.flatserve.validator.MessageResource;
import com.small_it_office.flatserve.validator.internal.MessageResourceHolder;
import com.small_it_office.flatserve.validator.internal.ValidatorConstants;
import com.small_it_office.flatserve.validator.rule.NumberFormat;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * BigDecimal^ɕϊRo[^B
 */
public class BigDecimalTypeConverter extends AbstractTypeConverter {

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected BigDecimal convert(String stringValue, Annotation[] annotations) {
		NumberFormat numberFormatAnnotation = AnnotationUtil.findAnnotation(annotations, NumberFormat.class);

		if (numberFormatAnnotation == null) {
			return toBigDecimal(stringValue);
		} else {
			return toBigDecimal(stringValue, numberFormatAnnotation.value());
		}
	}

	/**
	 * 񂩂BigDecimalIuWFNg𐶐܂B
	 * BigDecimal𐶐\ȕłȂꍇnullԂ܂B
	 * @param stringValue B
	 * @return BigDecimalIuWFNgB
	 */
	private BigDecimal toBigDecimal(String stringValue) {
		try {
			return new BigDecimal(stringValue);
		} catch (NumberFormatException e) {
			return null;
		}
	}

	/**
	 * 񂩂BigDecimalIuWFNg𐶐܂B
	 * formatStringŕ\tH[}bgɏ]l̕\łꍇɁABigDecimalIuWFNg𐶐ĕԂ܂B
	 * 񂪃tH[}bgɏ]ĂȂꍇ́AnullԂ܂B
	 * @param stringValue B
	 * @param formatString java.text.DecimalFormat̎dlɏ]tH[}bgB
	 * @return BigDecimalIuWFNgB
	 */
	private BigDecimal toBigDecimal(String stringValue, String formatString) {
		logger.debug("FSVLD-LOGD005", stringValue, formatString);
		DecimalFormat format = new DecimalFormat(formatString);
		format.setParseBigDecimal(true);
		ParsePosition position = new ParsePosition(0);
		Number parsed = format.parse(stringValue, position);
		if (parsed == null) {
			return null;
		}

		if (position.getIndex() < stringValue.length()) {
			return null;
		}

		//parsed́ANaNInfinity̏ꍇDouble^ƂȂBStringparseDoubleɂȂ\邩ǂ͕sB
		if (!(parsed instanceof BigDecimal)) {
			return null;
		}

		return (BigDecimal)parsed;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getErrorMessage(String value, Annotation[] annotations) {
		NumberFormat numberFormatAnnotation = AnnotationUtil.findAnnotation(annotations, NumberFormat.class);
		String format = numberFormatAnnotation == null ? null : numberFormatAnnotation.value();

		MessageResource messageResource = MessageResourceHolder.getInstance().get();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put(ValidatorConstants.MESSAGE_PLACEHOLDER_ERRORVALUE, value);
		map.put(ValidatorConstants.MESSAGE_PLACEHOLDER_NUMBERFORMAT, format);
		return messageResource.getMessage("{message.error.type.big_decimal}", map);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected Object getNullValue() {
		return null;
	}
}
