package com.small_it_office.flatserve.validator.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Map;

import com.small_it_office.flatserve.core.UnexpectedException;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.Header;
import com.small_it_office.flatserve.core.request.Param;
import com.small_it_office.flatserve.core.util.internal.AnnotationUtil;
import com.small_it_office.flatserve.validator.ValidationErrorCategory;
import com.small_it_office.flatserve.validator.ValidationErrors;
import com.small_it_office.flatserve.validator.rule.ItemName;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * JavaBeanɑ΂of[VsNXB
 */
public class BeanValidator {

	/**
	 * SingletonCX^XB
	 */
	private static BeanValidator instance = new BeanValidator();

	/**
	 * RXgN^B
	 */
	private BeanValidator() {
	}

	/**
	 * ̃NX̃CX^XԂ܂B
	 * @return BeanValidator̃CX^XB
	 */
	public static BeanValidator getInstance() {
		return instance;
	}

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * of[Vs܂B
	 * @param bean of[VΏۂ̃IuWFNgB
	 * @param rawParams HTTPNGXg擾lAIuWFNgɕϊȌԂŊi[MapB
	 */
	public void validate(Object bean, Map<String, Object> rawParams) {
		Class<?> beanType = bean.getClass();

		logger.debug("FSVLD-LOGD025", beanType.getName());

		Class<?> currentClass = beanType;
		while (currentClass != Object.class) {
			Field[] fields = currentClass.getDeclaredFields();
			for (Field field : fields) {
				field.setAccessible(true);
				String paramName;
				Annotation[] annotations = field.getAnnotations();
				if (AnnotationUtil.findAnnotation(annotations, Header.class) != null) {
					continue;
				}
				Param paramAnnotation = AnnotationUtil.findAnnotation(annotations, Param.class);
				if (paramAnnotation == null) {
					paramName = field.getName();
				} else {
					paramName = paramAnnotation.value();
				}
				ValidationRuleList ruleList = ValidationRuleList.assignRules(annotations);

				Object param;
				try {
					param = field.get(bean);
				} catch (IllegalAccessException e) {
					throw new UnexpectedException(e);
				}
				Object rawParam = rawParams.get(paramName);

				ValidationErrors errors = (ValidationErrors)RequestContext.get().getAttribute(
				        ValidatorConstants.ERRORS_STORE_KEY);
				if (errors.findError(paramName, ValidationErrorCategory.TYPE).size() > 0) {
					//z̏ꍇ͗vf̂ł^of[VG[ł΃[of[V͍sȂB
					logger.debug("FSVLD-LOGD018", paramName, rawParam);
					continue;
				}

				logger.debug("FSVLD-LOGD027", beanType.getName(), field.getName(), paramName);

				ItemName itemNameAnnotation = AnnotationUtil.findAnnotation(annotations, ItemName.class);
				String itemName = itemNameAnnotation == null ? null : itemNameAnnotation.value();
				ruleList.validateRules(paramName, rawParam, param, itemName);

				logger.debug("FSVLD-LOGD028", beanType.getName(), field.getName(), paramName);
			}
			currentClass = currentClass.getSuperclass();
		}
		logger.debug("FSVLD-LOGD026", beanType.getName());
	}
}
