package com.small_it_office.flatserve.validator.internal;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.validator.MessageResource;
import com.small_it_office.flatserve.validator.ValidationErrorCategory;
import com.small_it_office.flatserve.validator.ValidationErrors;
import com.small_it_office.flatserve.validator.internal.util.ErrorUtil;
import com.small_it_office.flatserve.validator.internal.util.TypeConvertUtil;
import com.small_it_office.flatserve.validator.rule.ValidationRule;
import com.small_it_office.flatserve.validator.rule.ValidationRuleClass;
import com.small_it_office.flatserve.validator.rule.ValidationRuleException;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;

/**
 * of[V[̃XgێNXłB
 * <p>
 * {@link #assignRules(Annotation[])}\bhŁAof[V[Ame[V̔znƂ
 * [̃Xg쐬A{@link #validateRules(String, Object, Object, String)}\bhŁA
 * lɑ΂ĂׂẴ[Ńof[V{܂B
 * </p>
 * <p>
 * ̃NXōsof[V́A[x[X̃of[VłA^of[V͊܂܂܂B
 * </p>
 */
public class ValidationRuleList {

	/**
	 * of[V[̃XgB
	 */
	private List<ValidationRule<?>> rules;

	/**
	 * of[Vs߂Ɏw肳ꂽAme[ṼXgB
	 */
	private List<Annotation> ruleAnnotations;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * RXgN^B
	 * @param rules of[V[̃Xg
	 * @param ruleAnnotations of[Vs߂Ɏw肳ꂽAme[ṼXg
	 */
	private ValidationRuleList(List<ValidationRule<?>> rules, List<Annotation> ruleAnnotations) {
		this.rules = rules;
		this.ruleAnnotations = ruleAnnotations;
	}

	/**
	 * w肳ꂽAme[VAKpׂof[V[̃Xg𐶐܂B
	 * @param annotations of[Vs߂Ɏw肳ꂽAme[V
	 * @return Kpׂof[V[̃Xgێ{@link ValidationRuleList}IuWFNg
	 */
	public static ValidationRuleList assignRules(Annotation[] annotations) {
		List<ValidationRule<?>> rules = new ArrayList<ValidationRule<?>>();
		List<Annotation> ruleAnnotations = new ArrayList<Annotation>();

		for (Annotation anno : annotations) {
			ValidationRuleClass ruleClassAnnotation = anno.annotationType().getAnnotation(ValidationRuleClass.class);
			if (ruleClassAnnotation != null) {
				ValidationRule<?> rule = createRuleInstance(ruleClassAnnotation);
				rules.add(rule);
				ruleAnnotations.add(anno);
			}
		}

		ValidationRuleList instance = new ValidationRuleList(rules, ruleAnnotations);

		return instance;
	}

	/**
	 * w肳ꂽNXof[V[IuWFNg𐶐܂B
	 * @param ruleClassAnnotation of[V[̃NX
	 * @return of[V[IuWFNg
	 */
	private static ValidationRule<?> createRuleInstance(ValidationRuleClass ruleClassAnnotation) {
		ValidationRule<?> rule;
		try {
			rule = ruleClassAnnotation.value().newInstance();
		} catch (Exception e) {
			throw new ValidationRuleException(Message.get("FSVLD-ERR002", ruleClassAnnotation.value().getName()), e);
		}
		return rule;
	}

	/**
	 * ێof[V[ɏ]āAl̃of[V{܂B
	 * <p>
	 * w肳ꂽlɑ΂āAXgŕێ邷ׂẴ[Ńof[Vs܂B
	 * ؂郋[̏́A{@link #assignRules(Annotation[])}\bḧŎw肳ꂽ
	 * Ame[V̏ɑΉ܂B
	 * </p>
	 * <p>
	 * Ώۂ̒lAɌ^of[VG[ł邱ƂĂꍇɂ́A[of[V͎sA
	 * ߂ltureԂ܂B
	 * </p>
	 * @param paramName of[Vsp[^̖O
	 * @param rawValue ͂ꂽ܂܂̒lBof[VΏۂ̒l^tH[}bg̕ϊȌԁB
	 * @param value of[VslB
	 * @param itemName G[bZ[Wɕ\ۂ̃p[^̕\Bw肵ȂꍇnullB
	 * @return of[VG[ȂA^of[VG[ɌoĂꍇɂtrueAG[falseB
	 */
	public boolean validateRules(String paramName, Object rawValue, Object value, String itemName) {

		if (!(value instanceof byte[]) && value != null && value.getClass().isArray()) {
			//oCgz͔zƂ݂͂ȂȂBɂ̂悤ȈKvȌ^邩H
			return validateRulesArray(paramName, rawValue, value, itemName);
		} else {
			return validateRulesNonArray(paramName, rawValue, value, itemName);
		}

	}

	/**
	 * złȂl̃of[Vs܂B
	 * @param paramName of[Vsp[^B
	 * @param rawValue ͂ꂽ܂܂̒lBof[VΏۂ̒l^tH[}bg̕ϊȌԁB
	 * @param value of[Vsl
	 * @param itemName G[bZ[Wɕ\ۂ̃p[^̕\Bw肵ȂꍇnullB
	 * @return  of[VG[ȂA^of[VG[ɌoĂꍇɂtrueAG[false
	 */
	private boolean validateRulesNonArray(String paramName, Object rawValue, Object value, String itemName) {
		ValidationErrors currentErrors = (ValidationErrors)RequestContext.get().getAttribute(ValidatorConstants.ERRORS_STORE_KEY);
		if (currentErrors.findError(paramName, ValidationErrorCategory.TYPE).size() > 0) {
			logger.debug("FSVLD-LOGD018", paramName, rawValue);
			return true;
		}

		String message = validateElement(paramName, rawValue, value, itemName);
		if (message != null) {
			String strRawValue = rawValue == null ? null : rawValue.toString();
			ErrorUtil.createValidationErrorObject(paramName, strRawValue, message, ValidationErrorCategory.RULE);
			return false;
		}
		return true;
	}

	/**
	 * z̃of[Vs܂B
	 * @param paramName of[Vsp[^B
	 * @param rawValue ͂ꂽ܂܂̒lBof[VΏۂ̒l^tH[}bg̕ϊȌԁB
	 * @param value of[Vsl
	 * @param itemName G[bZ[Wɕ\ۂ̃p[^̕\Bw肵ȂꍇnullB
	 * @return  of[VG[ȂA^of[VG[ɌoĂꍇɂtrueAG[false
	 */
	private boolean validateRulesArray(String paramName, Object rawValue, Object value, String itemName) {
		boolean result = true;

		ValidationErrors currentErrors = (ValidationErrors)RequestContext.get().getAttribute(ValidatorConstants.ERRORS_STORE_KEY);
		Object[] objArray = TypeConvertUtil.autoboxArray(value);
		Object[] rawValues = (Object[])rawValue;
		for (int i = 0; i < objArray.length; i++) {
			logger.debug("FSVLD-LOGD021", paramName, i + 1);
			if (currentErrors.findError(paramName, ValidationErrorCategory.TYPE, i) != null) {
				logger.debug("FSVLD-LOGD023", paramName, i + 1, rawValues[i]);
				return true;
			}
			String message = validateElement(paramName, rawValues[i], objArray[i], itemName);
			if (message != null) {
				//				String strRawValue = rawValues[i] == null ? null : rawValues[i].toString();
				String strRawValue = rawValues[i].toString();
				ErrorUtil.createValidationErrorObject(paramName, strRawValue, message, i, ValidationErrorCategory.RULE);
				result = false;
			}
			logger.debug("FSVLD-LOGD022", paramName, i + 1);
		}
		return result;
	}

	/**
	 * zł͂Ȃl̃of[VsAG[ꍇ̓G[bZ[W𐶐܂B
	 * @param paramName of[Vsp[^B
	 * @param rawValue ͂ꂽ܂܂̒lBof[VΏۂ̒l^tH[}bg̕ϊȌԁB
	 * @param value of[Vsl
	 * @param itemName G[bZ[Wɕ\ۂ̃p[^̕\Bw肵ȂꍇnullB
	 * @return of[VG[ꍇ̓G[bZ[WAȂnullB
	 */
	private String validateElement(String paramName, Object rawValue, Object value, String itemName) {
		MessageResource messageResource = MessageResourceHolder.getInstance().get();

		String message = null;
		for (int i = 0; i < rules.size(); i++) {
			@SuppressWarnings("rawtypes")
			ValidationRule rule = rules.get(i);

			logger.debug("FSVLD-LOGD019", rule.getClass().getName(), paramName, rawValue);
			@SuppressWarnings("unchecked")
			boolean validationResult = rule.isValid(value, rawValue, ruleAnnotations.get(i));
			logger.debug("FSVLD-LOGD020", rule.getClass().getName(), paramName, rawValue, validationResult);

			if (!validationResult) {
				@SuppressWarnings("unchecked")
				String tmpMessage = rule.getMessage(rawValue, ruleAnnotations.get(i), messageResource);
				message = ErrorUtil.addItemNameMessage(itemName, tmpMessage);
				break;
			}
		}
		return message;
	}

	/**
	 * P̃eXgp\bhB
	 * @return ێof[V[̃Xg
	 */
	List<ValidationRule<?>> getRules() {
		return rules;
	}

	/**
	 * P̃eXgp\bhB
	 * @return ێ郋[Ame[ṼXg
	 */
	List<Annotation> getRuleAnnotations() {
		return ruleAnnotations;
	}

}
