package com.small_it_office.flatserve.validator.internal.util;

import java.util.HashMap;
import java.util.Map;

import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.validator.MessageResource;
import com.small_it_office.flatserve.validator.ValidationError;
import com.small_it_office.flatserve.validator.ValidationErrorCategory;
import com.small_it_office.flatserve.validator.ValidationErrors;
import com.small_it_office.flatserve.validator.internal.MessageResourceHolder;
import com.small_it_office.flatserve.validator.internal.ValidatorConstants;

/**
 * of[VG[G[bZ[WɊւ郆[eBeBNXłB
 */
public class ErrorUtil {

	/**
	 * RXgN^B
	 */
	private ErrorUtil() {
	}

	/**
	 * bZ[WɁAG[ږt܂B
	 * <p>
	 * Ƃ΁AG[bZ[Wu`܂vA͍ږu[AhXvłꍇA
	 * u[AhXɌ肪܂B`܂vƂbZ[WԂ܂B
	 * ͍ږnull̏ꍇ́ÃbZ[Ŵ܂ܕԂ܂B
	 * ͍ږŜ{}ň͂܂Ăꍇ́A{}̕bZ[W\[X̃L[Ƃ݂ȂAbZ[W\[X
	 * ̂擾܂B
	 * </p>
	 * <p>
	 * ̗́uiږjɌ肪܂Bv͂́̕AbZ[W\[X"message.item_name"ƂL[
	 * w肷邱ƂŃJX^}CY\łB
	 * </p>
	 * @param itemName bZ[Wɕ\邽߂̍ږA܂̓bZ[W\[Xɓo^ꂽL[B
	 * @param message of[VG[bZ[W
	 * @return ږtof[VG[bZ[W
	 */
	public static String addItemNameMessage(String itemName, String message) {
		if (itemName == null) {
			return message;
		}
		MessageResource messageResource = MessageResourceHolder.getInstance().get();
		//itemName = messageResource.getMessage(itemName);
		Map<String, Object> itemNameMap = new HashMap<String, Object>();
		itemNameMap.put("ItemName", itemName);
		String itemNameMessage = messageResource.getMessage("{message.item_name}", itemNameMap);
		return itemNameMessage + message;
	}

	/**
	 * ReLXg񂩂of[VG[擾܂B
	 * @return of[VG[B
	 */
	public static ValidationErrors getValidationErrors() {
		return (ValidationErrors)RequestContext.get().getAttribute(ValidatorConstants.ERRORS_STORE_KEY);
	}

	/**
	 * of[VG[𐶐AReLXgɊi[܂B
	 * @param paramName of[VG[p[^̖O
	 * @param valueString of[VG[ƂȂl̕\
	 * @param message of[VG[bZ[W
	 * @param category ^of[VG[܂̓[of[VG[̋敪B
	 */
	public static void createValidationErrorObject(String paramName, String valueString, String message,
	        ValidationErrorCategory category) {
		createValidationErrorObject(paramName, valueString, message, 0, category);
	}

	/**
	 * z̒l̃of[VG[𐶐AReLXgɊi[܂B
	 * @param paramName of[VG[p[^̖O
	 * @param valueString of[VG[ƂȂl̕\
	 * @param message of[VG[bZ[W
	 * @param arrayIndex z̒́AG[ƂȂl̈ʒuCfbNX
	 * @param category ^of[VG[܂̓[of[VG[̋敪B
	 */
	public static void createValidationErrorObject(String paramName, String valueString, String message,
	        int arrayIndex, ValidationErrorCategory category) {
		ValidationError error = new ValidationError();
		error.setParameterName(paramName);
		error.setValue(valueString);
		error.setMessage(message);
		error.setArrayIndex(arrayIndex);
		error.setCategory(category);
		((ValidationErrors)RequestContext.get().getAttribute(ValidatorConstants.ERRORS_STORE_KEY)).add(error);
	}
}
