package com.small_it_office.flatserve.validator.mapping.internal;

import java.lang.annotation.Annotation;

import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.internal.NullObject;
import com.small_it_office.flatserve.validator.converter.internal.TypeConverter;
import com.small_it_office.flatserve.validator.converter.internal.TypeConverterFactory;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * {@link ValidationParameterMapping}̎łB
 */
public class ValidationParameterMappingImpl implements ValidationParameterMapping {

	/**
	 * }bsOΏۂ̈̌^B
	 */
	private Class<?> type;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * RXgN^B
	 * @param type }bsOΏۂ̈̌^B
	 */
	public ValidationParameterMappingImpl(Class<?> type) {
		this.type = type;
	}

	/**
	 * {@inheritDoc}
	 */
	public Object mapRawParameter(Annotation[] annotations, String paramName, Object readRawParam) {
		if (readRawParam != null) {
			//mapParameterŃfobOOo͂Ă̂ŁAd邽߂ł͏o͂ȂB
			return readRawParam;
		}

		if (paramName == null) {
			//mapParameterŃfobOOo͂Ă̂ŁAd邽߂ł͏o͂ȂB
			return null;
		}

		Object value = RequestContext.get().getRequestParams().get(paramName);
		if (value == null) {
			//mapParameterŃfobOOo͂Ă̂ŁAd邽߂ł͏o͂ȂB
			return null;
		}
		if (!(value instanceof String[])) {
			return null;
		}

		String[] stringValues = (String[])value;
		if (type.isArray()) {
			return stringValues;
		} else {
			return stringValues[0];
		}
	}

	/**
	 * {@inheritDoc}
	 */
	public Object mapParameter(Annotation[] annotations, String paramName, Object readParam) {

		//converter#nullValueł͂ȂAnullǂŔfB
		//int0Ă΁A͑̃vOC0ꂽƂƁB
		if (readParam != null && readParam != NullObject.getInstance()) {
			logger.debug("FSVLD-LOGD010", readParam);
			return readParam;
		}

		if (paramName == null) {
			logger.debug("FSVLD-LOGD003", type.getName());
			return null;
		}

		Object value = RequestContext.get().getRequestParams().get(paramName);
		if (value == null) {
			logger.debug("FSVLD-LOGD041", type.getName(), paramName);
			return null;
		}
		if (!(value instanceof String[])) {
			logger.debug("FSVLD-LOGD042", paramName, value);
			return null;
		}

		String[] stringValues = (String[])value;

		TypeConverter converter = TypeConverterFactory.getInstance().getConverter(type);

		return converter.getValue(paramName, stringValues, annotations);

	}

}
