package com.small_it_office.flatserve.validator.rule;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.small_it_office.flatserve.validator.rule.internal.MaxDigitsRule;


/**
 * Ώۂ̒l𐔒lƂĕ]AEꂼ̌̍őlK肵܂B
 * <p>
 * ̖0̏ꍇAƂĊ܂߂邱ƂɒӂĂB
 * Ƃ΁Aof[VΏۂ̒l"012.3400"Ƃ͒lłꍇǍ2Ǎ4ƂȂ܂B
 * ̏ꍇ2ł͂܂B
 * </p>
 * <p>
 * ̃[͐l^łȂAString^̈tB[hɓKpł܂B
 * A񂪐lƂĔFłȂꍇ͏Ƀof[VG[ƂȂ܂B
 * </p>
 * <p>
 * ̃[ł́A{@link NumberFormat}ɂtH[}bg̎w͍l܂B
 * </p>
 * <p>
 * <strong>̃[ł́A͒lnull܂͋󕶎̏ꍇ̓of[VG[ƂȂƂɒӂĂB</strong>
 * null󕶎eȂꍇ́AI{@link NotNull}܂{@link NotEmpty}w肷Kv܂B
 * </p>
 * <p>
 * &#64;MaxDigits(integer = 3, fraction = 2)Ǝw肵ꍇAȉɎl͎󂯓܂B
 * </p>
 * <ul>
 * <li>0</li>
 * <li>100</li>
 * <li>2.5</li>
 * <li>0150.12</li>
 * </ul>
 * <p>
 * [̎wŁAȉ̂悤Ȓl̓of[VG[ƂȂ܂B
 * </p>
 * <ul>
 * <li>0.001</li>
 * <li>1234</li>
 * <li>2.000</li>
 * <li>ABC</li>
 * </ul>
 */
@Documented
@ValidationRuleClass(MaxDigitsRule.class)
@Target({ElementType.PARAMETER, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface MaxDigits {

	/**
	 * ̍ő包B
	 * ftHglInteger.MAX_VALUEB
	 * w肷ƃof[Vs{@link ValidationRuleException}܂B
	 */
	int integer() default Integer.MAX_VALUE;

	/**
	 * ̍ő包B
	 * ftHgl0B
	 * w肷ƃof[Vs{@link ValidationRuleException}܂B
	 */
	int fraction() default 0;

	/**
	 * of[VG[bZ[WB
	 * {}Œu̎w肪\B
	 */
	String message() default "{message.error.max_digits}";
}
