package com.small_it_office.flatserve.validator.rule.internal;

import com.small_it_office.flatserve.validator.rule.AlphabetOrNumber;
import com.small_it_office.flatserve.validator.rule.MessageProcessValidationRule;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;


/**
 * lpp܂͐ł邱Ƃ؂of[V[NXłB
 * @see AlphabetOrNumber
 */
public class AlphabetOrNumberRule extends MessageProcessValidationRule<AlphabetOrNumber> {

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 */
	public boolean isValid(Object value, Object rawValue, AlphabetOrNumber annotation) {
		if (rawValue == null || "".equals(rawValue)) {
			return true;
		}

		if (!(rawValue instanceof String)) {
			logger.warn("FSVLD-LOGW003", annotation.annotationType().getSimpleName());
			return false;
		}
		return rawValue.toString().matches("[a-zA-Z0-9]*");
	}

}
