package com.small_it_office.flatserve.validator.rule.internal;

import java.math.BigDecimal;

import com.small_it_office.flatserve.validator.internal.util.TypeConvertUtil;
import com.small_it_office.flatserve.validator.rule.MaxDigits;
import com.small_it_office.flatserve.validator.rule.MessageProcessValidationRule;
import com.small_it_office.flatserve.validator.rule.ValidationRuleException;
import com.small_it_office.shared.meslog.message.Message;


/**
 * l̐Eꂼ̌w肵𒴂ȂƂ؂of[V[NXłB
 */
public class MaxDigitsRule extends MessageProcessValidationRule<MaxDigits> {

	/**
	 * {@inheritDoc}
	 */
	public boolean isValid(Object value, Object rawValue, MaxDigits annotation) {
		int maxFraction = annotation.fraction();
		int maxInteger = annotation.integer();
		if (maxFraction < 0 || maxInteger < 0) {
			throw new ValidationRuleException(Message.get("FSVLD-ERR010"));
		}

		if (rawValue == null || "".equals(rawValue)) {
			return true;
		}

		BigDecimal bValue = TypeConvertUtil.bigDecimalValueOf(value);
		if (bValue == null) {
			return false;
		}

		boolean fractionValid = bValue.scale() <= maxFraction;
		boolean integerValid = bValue.precision() - bValue.scale() <= maxInteger;

		return fractionValid & integerValid;
	}

}
