package com.small_it_office.flatserve.validator.rule.internal;

import java.math.BigDecimal;

import com.small_it_office.flatserve.validator.internal.util.TypeConvertUtil;
import com.small_it_office.flatserve.validator.rule.Max;
import com.small_it_office.flatserve.validator.rule.MessageProcessValidationRule;


/**
 * lw肳ꂽl𒴂ȂƂ؂of[V[NXłB
 */
public class MaxRule extends MessageProcessValidationRule<Max> {

	/**
	 * {@inheritDoc}
	 */
	public boolean isValid(Object value, Object rawValue, Max annotation) {
		if (rawValue == null || "".equals(rawValue)) {
			return true;
		}

		BigDecimal bValue = TypeConvertUtil.bigDecimalValueOf(value);
		if (bValue == null) {
			return false;
		}

		BigDecimal bMax = BigDecimal.valueOf(annotation.value());
		boolean allowEquiv = annotation.allowEquiv();

		return (bValue.compareTo(bMax) == -1) || (allowEquiv && bValue.compareTo(bMax) == 0);
	}

}
