package com.small_it_office.flatserve.validator.rule.internal;

import java.math.BigDecimal;

import com.small_it_office.flatserve.validator.internal.util.TypeConvertUtil;
import com.small_it_office.flatserve.validator.rule.MessageProcessValidationRule;
import com.small_it_office.flatserve.validator.rule.Min;


/**
 * lw肳ꂽlȂƂ؂of[V[NXłB
 */
public class MinRule extends MessageProcessValidationRule<Min> {

	/**
	 * {@inheritDoc}
	 */
	public boolean isValid(Object value, Object rawValue, Min annotation) {
		if (rawValue == null || "".equals(rawValue)) {
			return true;
		}

		BigDecimal bValue = TypeConvertUtil.bigDecimalValueOf(value);
		if (bValue == null) {
			return false;
		}

		BigDecimal bMin = BigDecimal.valueOf(annotation.value());
		boolean allowEquiv = annotation.allowEquiv();

		return (bValue.compareTo(bMin) == 1) || (allowEquiv && bValue.compareTo(bMin) == 0);
	}

}
