/*
 * Decompiled with CFR 0.152.
 */
package jp.botiboti.flextyle.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jp.botiboti.flextyle.util.Log;
import jp.botiboti.flextyle.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLUtil {
    private static final Logger log = new Log.LoggerFriend(){}.fxt();
    private static String DYNAMIC_ = "${";
    private static String _DYNAMIC = "}";
    private static String HOSTVAR_ = "?{";
    private static String _HOSTVAR = "}";
    private static Map<String, Parsed> cache = new HashMap<String, Parsed>();

    private SQLUtil() {
    }

    private static boolean isCacheMode() {
        return cache != null;
    }

    private static Parsed getFromCache(String sql) {
        return cache.get(sql);
    }

    private static void addToCache(String sql, Parsed parsed) {
        cache.put(sql, parsed);
    }

    public static Parsed parseAndReplace(String sql, Map<String, Object> params) {
        return SQLUtil.parseAndReplace(sql, params, -1);
    }

    public static Parsed parseAndReplace(String sql, Map<String, Object> params, int index) {
        Parsed parsed = null;
        if (!SQLUtil.isCacheMode() || (parsed = SQLUtil.getFromCache(sql)) == null) {
            String replaced = Util.replace(sql, params, index, DYNAMIC_, _DYNAMIC);
            parsed = SQLUtil.replaceHostvar(replaced);
            if (SQLUtil.isCacheMode()) {
                SQLUtil.addToCache(replaced, parsed.createCopy());
            }
        } else {
            parsed = parsed.createCopy();
        }
        if (parsed.parameter != null) {
            SQLUtil.applyParameter(parsed, params, index);
        }
        return parsed;
    }

    public static Parsed parseAndReplace(String sql, List<Object> list) {
        Parsed parsed = null;
        if (!SQLUtil.isCacheMode() || (parsed = SQLUtil.getFromCache(sql)) == null) {
            parsed = SQLUtil.replaceHostvar(sql);
            if (SQLUtil.isCacheMode()) {
                SQLUtil.addToCache(sql, parsed.createCopy());
            }
        } else {
            parsed = parsed.createCopy();
        }
        if (parsed.parameter != null) {
            parsed.parameter = list;
        }
        return parsed;
    }

    private static Parsed replaceHostvar(String sql) {
        Parsed result = new Parsed();
        String[] partsSQL = Util.split(sql, HOSTVAR_);
        if (partsSQL.length == 1) {
            result.query = sql;
            return result;
        }
        StringBuffer buf = new StringBuffer(partsSQL[0]);
        int i = 1;
        while (i < partsSQL.length) {
            String[] splited = Util.split(partsSQL[i], _HOSTVAR, 2);
            if (splited == null || splited.length == 1) {
                log.fine("SQL\u306e\u7f6e\u304d\u63db\u3048\u90e8\u5206 ?{} \u306e\u8a18\u8ff0\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059.");
                buf.append(partsSQL[i]);
            } else {
                if (result.parameter == null) {
                    result.parameter = new ArrayList<Object>();
                }
                result.parameter.add(splited[0]);
                buf.append("?").append(splited[1]);
            }
            ++i;
        }
        result.query = buf.toString();
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static void applyParameter(Parsed sql, Map<String, Object> params, int index) {
        parameters = new ArrayList<Object>();
        i = 0;
        while (sql.parameter != null && i < sql.parameter.size()) {
            key = (String)sql.parameter.get(i);
            isIndexedParams = false;
            if (params.get(key) != null) ** GOTO lbl14
            if (key.indexOf(91) <= 0 || params.get(key.substring(0, key.indexOf(91))) == null) {
                SQLUtil.log.fine("SQL\u306e\u7f6e\u304d\u63db\u3048\u90e8\u5206[" + key + "]\u306b\u8a72\u5f53\u3059\u308b\u5024\u304cNULL\u3067\u3059:" + params);
                parameters.add(null);
            } else {
                isIndexedParams = key.trim().endsWith("[n]") != false || key.trim().endsWith("[i]") != false;
                key = key.substring(0, key.indexOf(91));
lbl14:
                // 2 sources

                obj = params.get(key);
                if (isIndexedParams && (obj.getClass().isArray() || obj instanceof List)) {
                    parameters.add(obj instanceof List != false ? ((List)obj).get(index) : ((Object[])obj)[index]);
                } else if (obj.getClass().isArray() || obj instanceof List) {
                    parameters.add(obj instanceof List != false ? ((List)obj).get(0) : ((Object[])obj)[0]);
                } else {
                    parameters.add(obj);
                }
            }
            ++i;
        }
        sql.parameter = parameters;
    }

    public static class Parsed {
        public String query;
        public List<Object> parameter;

        public Parsed createCopy() {
            Parsed copy = new Parsed();
            copy.query = this.query;
            copy.parameter = this.parameter;
            return copy;
        }
    }
}

