/*
 * Decompiled with CFR 0.152.
 */
package jp.botiboti.flextyle.extension;

import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import jp.botiboti.flextyle.core.ConnectionFactory;
import jp.botiboti.flextyle.util.Util;
import org.apache.tomcat.dbcp.dbcp.cpdsadapter.DriverAdapterCPDS;
import org.apache.tomcat.dbcp.dbcp.datasources.SharedPoolDataSource;

public class ConnectionFactoryForTomcat
extends ConnectionFactory {
    protected static void initialize(Properties prop) {
        String driverName = prop.getProperty("driverClass");
        try {
            DriverAdapterCPDS cpds = new DriverAdapterCPDS();
            cpds.setDriver(driverName);
            cpds.setUrl(prop.getProperty("url"));
            cpds.setUser(prop.getProperty("user"));
            cpds.setPassword(prop.getProperty("password"));
            SharedPoolDataSource tds = new SharedPoolDataSource();
            tds.setConnectionPoolDataSource((ConnectionPoolDataSource)cpds);
            if (Util.isNotNullOrBlank(prop.getProperty("maxActive")) && Util.isNumber(prop.getProperty("maxActive"))) {
                tds.setMaxActive(Integer.parseInt(prop.getProperty("maxActive")));
            }
            if (Util.isNotNullOrBlank(prop.getProperty("maxWait")) && Util.isNumber(prop.getProperty("maxWait"))) {
                tds.setMaxWait(Integer.parseInt(prop.getProperty("maxWait")));
            }
            ConnectionFactoryForTomcat.initialize((DataSource)tds);
        }
        catch (ClassNotFoundException exp) {
            System.out.println("JDBC Driver[" + driverName + "] is not found.");
        }
    }
}

