/*
 * Decompiled with CFR 0.152.
 */
package jp.botiboti.flextyle.extension;

import java.sql.Timestamp;
import jp.botiboti.flextyle.core.RecordSet;
import jp.botiboti.flextyle.util.DateTime;
import jp.botiboti.flextyle.util.DateUtil;
import jp.botiboti.flextyle.util.Util;

public class RecordSetUtil {
    public static final RecordSet.Itr itrNullToBlank() {
        return new RecordSet.Itr(){

            public Object process(Object val) {
                return val == null ? "" : val;
            }
        };
    }

    public static final RecordSet.Itr itrBlankToNull() {
        return new RecordSet.Itr(){

            public Object process(Object val) {
                return val != null && val.equals("") ? null : val;
            }
        };
    }

    public static final RecordSet.Itr itrFill(final int size) {
        return new RecordSet.Itr(){

            public Object process(Object val) {
                return val instanceof String ? Util.fill((String)val, size) : val;
            }
        };
    }

    public static final RecordSet.Itr itrReplace(final String regex, final String replacement) {
        return new RecordSet.Itr(){

            public Object process(Object val) {
                return val instanceof String ? ((String)val).replaceAll(regex, replacement) : val;
            }
        };
    }

    public static final RecordSet.Itr itrStrAppend(final String s) {
        return new RecordSet.Itr(){

            public Object process(Object val) {
                return val + s;
            }
        };
    }

    public static final RecordSet.Itr itrStrPrepend(final String s) {
        return new RecordSet.Itr(){

            public Object process(Object val) {
                return String.valueOf(s) + val;
            }
        };
    }

    public static final RecordSet.Itr itrInsert(final int pos, final String str) {
        return new RecordSet.Itr(){

            public Object process(Object val) {
                return val instanceof String ? Util.insert((String)val, pos, str) : val;
            }
        };
    }

    public static final RecordSet.Itr itrRemove(String regex) {
        return RecordSetUtil.itrReplace(regex, "");
    }

    public static final RecordSet.Itr itrToInt() {
        return new RecordSet.Itr(){

            public Object process(Object val) {
                if (val != null && val instanceof String) {
                    return val.equals("") ? null : new Integer(((String)val).replaceAll(",", ""));
                }
                return val;
            }
        };
    }

    public static final RecordSet.Itr itrToString() {
        return new RecordSet.Itr(){

            public Object process(Object val) {
                return val == null && val instanceof String ? val : val.toString();
            }
        };
    }

    public static final RecordSet.Itr itrFmtDate() {
        return new RecordSet.Itr(){

            public Object process(Object val) {
                if (val instanceof Timestamp) {
                    return DateUtil.toYYYYMMDDf((Timestamp)val);
                }
                return val;
            }
        };
    }

    public static final RecordSet.Itr itrDigitAddMMDD() {
        return new RecordSet.Itr(){

            public Object process(Object val) {
                if (val == null) {
                    return null;
                }
                String[] array = val.toString().split("/");
                if (array.length != 3) {
                    return val;
                }
                return String.valueOf(array[0]) + String.format("/%02d/%02d", Integer.parseInt(array[1]), Integer.parseInt(array[2]));
            }
        };
    }

    public static final RecordSet.Itr itrParseDate(final String pattern) {
        return new RecordSet.Itr(){

            public Object process(Object obj) {
                if (Util.isNullOrBlank((String)obj)) {
                    return null;
                }
                return DateTime.parse((String)obj, pattern);
            }
        };
    }
}

