/*
 * Decompiled with CFR 0.152.
 */
package jp.botiboti.flextyle.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import jp.botiboti.flextyle.util.DateUtil;

public class DateTime
extends Timestamp {
    private static final long serialVersionUID = -1226885865005125752L;

    public DateTime() {
        super(System.currentTimeMillis());
    }

    public DateTime(Date t) {
        super(t.getTime());
    }

    public DateTime(long l) {
        super(l);
    }

    public DateTime(Calendar cal) {
        super(cal.getTime().getTime());
    }

    public static DateTime today() {
        return new DateTime(DateUtil.today());
    }

    public static DateTime now() {
        return new DateTime(DateUtil.now());
    }

    public static DateTime parse(String src, String format) {
        try {
            return new DateTime(new SimpleDateFormat(format).parse(src));
        }
        catch (ParseException exp) {
            throw new IllegalArgumentException("Date format [" + format + "] is invalid for " + src + ".");
        }
    }

    public static DateTime parseYYYYMMDD(String src) {
        return DateTime.parse(src, "yyyyMMdd");
    }

    public static DateTime parseYYYYMM(String src) {
        return DateTime.parse(src, "yyyyMM");
    }

    public DateTime clearTime() {
        return new DateTime(DateTime.resetTime(this.cal()));
    }

    public DateTime beforeNHour(int n) {
        return this.afterNHour(n * -1);
    }

    public DateTime afterNHour(int n) {
        Calendar cal = this.cal();
        cal.add(11, n);
        return new DateTime(cal);
    }

    public int dayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this);
        return cal.get(7);
    }

    public DateTime prevDay(DateTime date) {
        Calendar cal = this.cal();
        cal.add(5, -1);
        return new DateTime(cal);
    }

    public DateTime nextDay() {
        Calendar cal = this.cal();
        cal.add(5, 1);
        return new DateTime(cal);
    }

    public DateTime beforeNDay(int n) {
        Calendar cal = this.cal();
        cal.add(5, -n);
        return new DateTime(cal);
    }

    public DateTime afterNDay(int n) {
        Calendar cal = this.cal();
        cal.add(5, n);
        return new DateTime(cal);
    }

    public DateTime prevMonth() {
        return this.beforeNMonth(1);
    }

    public DateTime nextMonth() {
        return this.afterNMonth(1);
    }

    public DateTime beforeNMonth(int n) {
        Calendar cal = this.cal();
        cal.add(2, -n);
        return new DateTime(cal);
    }

    public DateTime afterNMonth(int n) {
        Calendar cal = this.cal();
        cal.add(2, n);
        return new DateTime(cal);
    }

    public DateTime beforeNYear(int n) {
        Calendar cal = this.cal();
        cal.add(1, -n);
        return new DateTime(cal);
    }

    public DateTime afterNYear(int n) {
        Calendar cal = this.cal();
        cal.add(1, n);
        return new DateTime(cal);
    }

    public static DateTime firstOfYearCycle(Integer year) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(year, 3, 1);
        DateTime.resetTime(cal);
        return new DateTime(cal);
    }

    public static DateTime lastOfYearCycle(Integer year) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(year + 1, 2, 31);
        DateTime.resetTime(cal);
        return new DateTime(cal);
    }

    public DateTime firstOfYearCycle() {
        Calendar cal = this.cal();
        int year = cal.get(1);
        int month = cal.get(2);
        if (month < 3) {
            --year;
        }
        cal.set(year, 3, 1);
        DateTime.resetTime(cal);
        return new DateTime(cal);
    }

    public DateTime lastOfYearCycle() {
        Calendar cal = this.cal();
        int year = cal.get(1);
        int month = cal.get(2);
        if (month < 3) {
            --year;
        }
        cal.set(year + 1, 2, 31);
        DateTime.resetTime(cal);
        return new DateTime(cal);
    }

    public Integer yearCycle() {
        Calendar cal = this.cal();
        int year = cal.get(1);
        int month = cal.get(2);
        if (month < 3) {
            --year;
        }
        return new Integer(year);
    }

    public DateTime firstOfMonth() {
        Calendar cal = this.cal();
        cal.set(5, 1);
        return new DateTime(cal);
    }

    public DateTime lastOfMonth() {
        Calendar cal = this.cal();
        cal.set(5, 1);
        cal.add(2, 1);
        cal.add(5, -1);
        return new DateTime(cal);
    }

    public DateTime firstOfNextMonth() {
        Calendar cal = this.cal();
        cal.set(5, 1);
        cal.add(2, 1);
        return new DateTime(cal);
    }

    public DateTime firstOfPrevMonth() {
        Calendar cal = this.cal();
        cal.set(5, 1);
        cal.add(2, -1);
        return new DateTime(cal);
    }

    public boolean isFirstOfMonth() {
        return this.getTime() == this.firstOfMonth().getTime();
    }

    public boolean isLastOfMonth(DateTime date) {
        return this.getTime() == this.lastOfMonth().getTime();
    }

    public int getYear() {
        Calendar cal = this.cal();
        return cal.get(1);
    }

    public int getMonth() {
        Calendar cal = this.cal();
        return cal.get(2);
    }

    public int getDate() {
        Calendar cal = this.cal();
        return cal.get(5);
    }

    public String toYYYYMMDD() {
        Calendar cal = this.cal();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int dt = cal.get(5);
        return String.valueOf(year * 10000 + month * 100 + dt);
    }

    public String toYYYYMM() {
        Calendar cal = this.cal();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        return String.valueOf(year * 100 + month);
    }

    public String toYYYY() {
        Calendar cal = this.cal();
        return String.valueOf(cal.get(1));
    }

    public String toDD() {
        return String.valueOf(this.getDate());
    }

    public String toYYYYMMDDf() {
        return this.toYYYYMMDDf("/");
    }

    public String toYYYYMMDDf(String delim) {
        Calendar cal = this.cal();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int dt = cal.get(5);
        return String.valueOf(String.valueOf(year * 10000) + delim + month * 100 + delim + dt);
    }

    public String toYYYYMMf() {
        return this.toYYYYMMf("/");
    }

    public String toYYYYMMf(String delim) {
        Calendar cal = this.cal();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        String month_ = String.valueOf(month);
        if (month < 10) {
            month_ = "0" + month_;
        }
        return String.valueOf(String.valueOf(year) + delim + month_);
    }

    public String toHHMMf() {
        return this.toHHMMf(":");
    }

    public String toHHMMf(String delim) {
        Calendar cal = this.cal();
        int hour = cal.get(11);
        int minute = cal.get(12);
        StringBuffer buf = new StringBuffer();
        (hour < 10 ? buf.append("0") : buf).append(hour);
        buf.append(delim);
        (minute < 10 ? buf.append("0") : buf).append(minute);
        return buf.toString();
    }

    private Calendar cal() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this);
        return cal;
    }

    private static Calendar resetTime(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }
}

