/*
 * Decompiled with CFR 0.152.
 */
package jp.botiboti.flextyle.util;

import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.botiboti.flextyle.util.LogFormatter;

public class Log {
    protected static final Logger parent = Logger.getLogger("flextyle");
    protected static final Logger fxt = Logger.getLogger("flextyle.framework");
    public static final Logger app = Logger.getLogger("flextyle.application");

    static {
        Log.initialize();
    }

    private static void initialize() {
        if (fxt.getHandlers() != null && fxt.getHandlers().length > 0 || app.getHandlers() != null && app.getHandlers().length > 0) {
            return;
        }
        try {
            File f = new File("./logs");
            if (!f.exists()) {
                f.mkdir();
            }
            FileHandler fHandler = new FileHandler("./logs/flextyle.%u.log", true);
            fHandler.setLevel(Level.INFO);
            fHandler.setFormatter(new LogFormatter());
            ConsoleHandler cHandler = new ConsoleHandler();
            cHandler.setLevel(Level.FINE);
            cHandler.setFormatter(new LogFormatter());
            parent.addHandler(fHandler);
            parent.addHandler(cHandler);
            parent.setUseParentHandlers(false);
            parent.setLevel(Level.FINE);
        }
        catch (IOException ex) {
            System.out.println("[Fetal] \u30ed\u30ac\u30fc\u306e\u521d\u671f\u5316\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u4ee5\u964d\u3001\u30ed\u30b0\u304c\u6b63\u3057\u304f\u51fa\u529b\u3055\u308c\u306a\u3044\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059.");
            ex.printStackTrace(System.out);
        }
    }

    public static class LoggerFriend {
        private static final String allowed = "jp.botiboti.flextyle";

        protected LoggerFriend() {
            if (this.getClass().getName().startsWith(allowed)) {
                return;
            }
            throw new RuntimeException(String.valueOf(this.getClass().getName()) + "is not allowed to access");
        }

        public Logger fxt() {
            return fxt;
        }
    }
}

