/*
 * Decompiled with CFR 0.152.
 */
package jp.botiboti.flextyle.util;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    public synchronized String format(LogRecord aRecord) {
        StringBuffer message = new StringBuffer(131);
        message.append(String.format("%tD %<tT.%<tL", aRecord.getMillis()));
        message.append(' ');
        message.append(aRecord.getThreadID());
        message.append(' ');
        message.append(aRecord.getLevel().toString());
        message.append(' ');
        String className = aRecord.getSourceClassName();
        message.append(className != null ? className : aRecord.getLoggerName());
        message.append("::");
        String methodName = aRecord.getSourceMethodName();
        message.append(methodName != null ? methodName : "N/A");
        message.append(" ");
        message.append(this.formatMessage(aRecord));
        message.append('\n');
        Throwable throwable = aRecord.getThrown();
        if (throwable != null) {
            message.append(throwable.toString());
            message.append('\n');
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement trace = stackTraceElementArray[n2];
                message.append('\t');
                message.append(trace.toString());
                message.append('\n');
                ++n2;
            }
        }
        return message.toString();
    }
}

