/*
 * Decompiled with CFR 0.152.
 */
package jp.botiboti.flextyle.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jp.botiboti.flextyle.core.SystemException;
import jp.botiboti.flextyle.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final Logger log = new Log.LoggerFriend(){}.fxt();

    private Util() {
    }

    public static String fill(Object src, int size) {
        return src instanceof String ? Util.fill((String)src, size, ' ') : src.toString();
    }

    public static boolean notEquals(String str1, String str2) {
        return str1 != str2 && (str1 == null || !str1.equals(str2));
    }

    public static boolean isNullOrBlank(String str1) {
        return str1 == null || str1.equals("");
    }

    public static boolean isNotNullOrBlank(String str1) {
        return str1 != null && !str1.equals("");
    }

    public static boolean isNumber(String str) {
        int i = 0;
        int max = str.length();
        while (i < max) {
            char c = str.charAt(i);
            if (c < '0' && c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String fill(String src, int size, char ch) {
        if (src.length() >= size) {
            return src;
        }
        StringBuffer buf = new StringBuffer(src);
        while (buf.length() < size) {
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String zeroPad(Number src, int size) {
        int iSrc = src.intValue();
        if ((double)iSrc >= Math.pow(10.0, size - 1)) {
            return src.toString();
        }
        StringBuffer buf = new StringBuffer().append(iSrc);
        while (buf.length() < size) {
            buf.insert(0, "0");
        }
        return buf.toString();
    }

    public static String trim(Object src) {
        return src != null ? src.toString().trim() : (String)src;
    }

    public static String trimW(String str) {
        int SPACE = 32;
        int ZSPACE = 12288;
        if (str == null) {
            return null;
        }
        int head = 0;
        int tail = str.length() - 1;
        int i = 0;
        int length = str.length();
        while (i < length) {
            char c = str.charAt(i);
            if (c != ' ' && c != '\u3000') break;
            ++head;
            ++i;
        }
        i = str.length() - 1;
        while (i > head) {
            char c = str.charAt(i);
            if (c != ' ' && c != '\u3000') break;
            --tail;
            --i;
        }
        return str.substring(head, tail + 1);
    }

    public static <T> T ifnull(T obj, T replace) {
        return obj == null ? replace : obj;
    }

    public static String nullToBlank(String str) {
        return Util.ifnull(str, "");
    }

    public static String blankToNull(String str) {
        return "".equals(str) ? null : str;
    }

    public static String[] split(String str, String separator) {
        return Util.split(str, separator, Integer.MAX_VALUE);
    }

    public static String[] split(String str, String separator, int count) {
        ArrayList<String> list = null;
        int index = 0;
        int i = 1;
        while (i < count && str.indexOf(separator, index) != -1) {
            if (list == null) {
                list = new ArrayList<String>();
            }
            int tmpIndex = str.indexOf(separator, index);
            list.add(str.substring(index, tmpIndex));
            index = tmpIndex + separator.length();
            ++i;
        }
        if (list == null) {
            return new String[]{str};
        }
        list.add(str.substring(index));
        return list.toArray(new String[list.size()]);
    }

    public static String insert(String src, int pos, String str) {
        return src.length() < pos ? src : String.valueOf(src.substring(0, pos)) + str + src.substring(pos);
    }

    public static String toMD5(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            byte[] digest = md.digest();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < digest.length) {
                sb.append(Integer.toHexString(digest[i] >> 4 & 0xF));
                sb.append(Integer.toHexString(digest[i] & 0xF));
                ++i;
            }
            return new String(sb);
        }
        catch (NoSuchAlgorithmException exp) {
            throw new SystemException("\u6697\u53f7\u5316\u65b9\u5f0f[MD5]\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002", exp);
        }
    }

    public static String replace(String str, Map<String, Object> params) {
        return Util.replace(str, params, 0);
    }

    public static String replace(String str, Map<String, Object> params, int index) {
        return Util.replace(str, params, index, "${", "}");
    }

    public static String replace(String str, Map<String, Object> params, int index, String BEGIN_, String _END) {
        String[] partsSQL = Util.split(str, BEGIN_);
        if (partsSQL.length == 1) {
            return str;
        }
        StringBuffer buf = new StringBuffer(partsSQL[0]);
        int i = 1;
        while (i < partsSQL.length) {
            String[] splited = Util.split(partsSQL[i], _END, 2);
            if (splited == null || splited.length == 1) {
                log.fine("\u6587\u5b57\u5217\u306e\u7f6e\u304d\u63db\u3048\u90e8\u5206 ${} \u306e\u8a18\u8ff0\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059.");
                buf.append(partsSQL[i]);
            } else {
                String paramKey;
                boolean isIndexedParams = splited[0].trim().endsWith("[n]") || splited[0].trim().endsWith("[i]");
                String string = paramKey = isIndexedParams ? splited[0].substring(0, splited[0].length() - 3) : splited[0];
                if (params.get(paramKey) == null) {
                    log.fine("\u6587\u5b57\u5217\u306e\u7f6e\u304d\u63db\u3048\u90e8\u5206[" + paramKey + "]\u306b\u8a72\u5f53\u3059\u308b\u5024\u304c\u3042\u308a\u307e\u305b\u3093:" + params);
                    buf.append(partsSQL[i]);
                } else {
                    Object obj = params.get(paramKey);
                    if (obj.getClass().isArray() || obj instanceof List) {
                        Object[] objs;
                        Object[] objectArray = objs = obj instanceof List ? ((List)obj).toArray() : (Object[])obj;
                        if (isIndexedParams) {
                            buf.append((Object)Util.ifnull(objs[index], ""));
                        } else {
                            buf.append((Object)Util.ifnull(objs[0], ""));
                        }
                    } else {
                        buf.append((Object)Util.ifnull(obj, ""));
                    }
                    buf.append(splited[1]);
                }
            }
            ++i;
        }
        return buf.toString();
    }
}

