package jp.botiboti.flextyle.core;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

/**
 * f[^x[Xւ̐ڑs߂̏𒊏ot@Ng[NX.
 * @author tanaka ken
 */
public class ConnectionFactory {

  private static final String defaultJndiName_ = "java:comp/env/jdbc/datasource";

  protected static void initialize(DataSource dataSource) {
  	dataSource_ = dataSource;
  }

  protected static void initialize() {
  	initialize(defaultJndiName_);
  }
  
  protected static void initialize(String jndi) {
  	try {
    	initialize((DataSource) new InitialContext().lookup(jndi));
  	}
    catch (NamingException ex) {
      throw new SystemException("failure for lookup datasource.:" + jndi, ex);
    }
  }
  
  protected static void initialize(String driverName, String connectString) {
  	initialize(driverName, connectString, null);
  }

  protected static void initialize(String driverName, String connectString, Properties props) {
  	initialize(driverName, connectString, null, null, props);
  }

  protected static void initialize(String driverName, String connectString, String userName, String password) {
  	initialize(driverName, connectString, userName, password, null);
  }

  protected static void initialize(String driverName, String connectString, String userName, String password, Properties props) {
  	setting_ = new JDBCSetting();
  	setting_.driverClassName = driverName;
  	setting_.connectString = connectString;
  	setting_.userName = userName;
  	setting_.password = password;
  	setting_.properties = props;
  }

  /**
   * data source
   */
  private static DataSource dataSource_ = null;
  
  /**
   * jdbc setting (if you don't use DataSource)
   */
  private static JDBCSetting setting_ = null;
  
  private static class JDBCSetting {
  	String driverClassName = null;
  	String connectString = null;
  	String userName = null;
  	String password = null;
  	Properties properties = null;
  }
  
  static final Connection getConnection() {

    if (dataSource_ == null && setting_ == null) 
    	initialize();

    try {  
      if (dataSource_ != null) 
        	return dataSource_.getConnection();
       
      else {
      	Class.forName(setting_.driverClassName);
      	
      	if (setting_.userName != null && setting_.password != null) 
      		return DriverManager.getConnection(setting_.connectString, setting_.userName, setting_.password);
      	
      	else if (setting_.properties != null) 
      		return DriverManager.getConnection(setting_.connectString, setting_.properties);
      	
      	else 
      		return DriverManager.getConnection(setting_.connectString);      	
      }
    }
    catch (ClassNotFoundException ex) {
      throw new SystemException("f[^x[XhCoNX܂.", ex);
    }
    catch (SQLException ex) {
      throw new SystemException("f[^\[XRlNV擾ł܂.", ex);
    }
  }
  
  protected ConnectionFactory() { }
}
