package jp.botiboti.flextyle.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import jp.botiboti.flextyle.util.Log;

/**
 * f[^x[XsAׂẴrWlXWbN̊NX.
 * SQLuAуgUNVǗ̂߂̊e탁\bh񋟂܂.
 * 
 * @author tanaka ken
 */
abstract public class DBConnect {

	private static final RecordSet.RecordSetFriend friendCaller = new RecordSet.RecordSetFriend() { };
	private static final Logger log = new Log.LoggerFriend() { }.fxt();
	
	/**
	 * [ Ci[NX ] 
	 * gUNVXR[ṽf[^ێ邽߂̃NX.
	 * ÃNX̃CX^X̓TuNXŊǗz. 
	 */
	protected static class TransactionContext {

		/** f[^x[Xւ̐ڑ */
		private Connection conn_ = null;

		private Connection conn() throws SQLException {
			if (this.conn_ == null) {
				// caANZX
				this.conn_ = ConnectionFactory.getConnection();
				this.conn_.setAutoCommit(false);
			}
			return conn_;
		}

		private boolean isOpenConnection() {
			try { 
				return (conn_ != null)? !conn_.isClosed(): false;
			} catch (SQLException ex) {
				return false;
			}
		}

		/**
		 * f[^x[Xɑ΂関R~bg̏C邩ǂ킷tO. 
		 * INSERT,UPDATE,DELETE ̂ǂꂩsꂽƂtrue ƂȂA commit(), rollback() 
		 * ̂ǂ炩Ă΂ꂽƂfalse ƂȂ܂.
		 */
		private boolean changed_ = false;

		private void DB_Changed() {
			this.changed_ = true;
		}

		private void DB_NotChanged() {
			this.changed_ = false;
		}

		private boolean isDBChanged() {
			return this.changed_;
		}
		
	};// end of [Ci[NX]
	
	/**
	 * @return gUNVReLXg̃CX^X擾
	 * gUNVReLXg̃CX^X̓TuNXŊǗ
	 * ƂOƂĂ,
	 */
	abstract protected TransactionContext getTrxContext();
	
	/**
	 * INSERT AUPDATE ADELETE s܂.
	 * 
	 * @param sql
	 *            String SQL 
	 * @return int ߂lijava.sql.Statement.executeUpdate Ɠj
	 */
	public int SQL_Update(String sql) {
		return SQL_Update(sql, (Map<String,Object>) null);
	}

	public int SQL_Update(String sql, RecordSet params) {
		return SQL_Update(sql, DBConnect.friendCaller.getMap(params));
	}

	public int SQL_Update(String sql, RecordSet params, int index) {
		return SQL_Update(sql, DBConnect.friendCaller.getMap(params), index);
	}

	public int SQL_Update(String sql, Map<String,Object> params) {
		return SQL_Update(sql, params, -1);
	}

	public int SQL_Update(String sql, Map<String,Object> params, int index) {

		// SQL̕u
		return SQL_Update((params != null) ? SQLUtil.parseAndReplace(sql, params, index) : null, sql);
	}

	public int SQL_Update(String sql, Object... args) {

		Object[] objs = args;

		// SQL̕u
		return SQL_Update((args != null) ? SQLUtil.parseAndReplace(sql, Arrays.asList(objs)) : null, sql);
	}

	private int SQL_Update(final SQLUtil.Parsed parsedSQL, String sql) {
		
		String query = (parsedSQL == null) ? sql : parsedSQL.query;

		return SQL_Update(query, new SQLUpdateCall() {
			public int impl(PreparedStatement stmt) throws SQLException {

				// SQLzXgϐ̒u
				for (int i = 0; parsedSQL != null
						&& parsedSQL.parameter != null
						&& i < parsedSQL.parameter.size(); i++) {
					
					stmt.setObject(i + 1, parsedSQL.parameter.get(i));
				}
				return stmt.executeUpdate();
			}
		});
	}

	public int SQL_Update(String sql, SQLUpdateCall caller) {
		PreparedStatement stmt = null;
		try {

			log.fine("SQL: " + sql);

			stmt = this.getTrxContext().conn().prepareStatement(sql);
			int cnt = caller.impl(stmt);

			if (cnt != 0) {
				// f[^ύXtOuύXv
				this.getTrxContext().DB_Changed();
			}
			return cnt;
		} catch (SQLException ex) {
			throw new SystemException("f[^x[X֘Ȁł̃G[Lb`܂B", ex);
		} finally {
			try {
				if (stmt != null)
					stmt.close();
			} catch (SQLException ex) {
				throw new SystemException("Xe[ggN[Y鏈ŃG[܂B", ex);
			}
		}
	}

	/**
	 * SELECT sAʂ RecordSet IuWFNgɊi[ĕԂ܂.
	 * 
	 * @param sql String SQL 
	 * @return RecordSet R[hZbgIuWFNg
	 */
	public RecordSet SQL_Query(String sql) {
		return SQL_Query(sql, (Map<String,Object>) null);
	}

	public RecordSet SQL_Query(String sql, RecordSet params) {
		return SQL_Query(sql, DBConnect.friendCaller.getMap(params));
	}

	public RecordSet SQL_Query(String sql, RecordSet params, int index) {
		return SQL_Query(sql, DBConnect.friendCaller.getMap(params), index);
	}

	public RecordSet SQL_Query(String sql, Map<String,Object> params) {
		return SQL_Query(sql, params, -1);
	}

	public RecordSet SQL_Query(String sql, Map<String,Object> params, int index) {

		// SQL̕u 
		return SQL_Query((params != null) ? SQLUtil.parseAndReplace(sql, params, index) : null, sql);
	}
	
	/** ̃\bhł́ASQL̃zXgϐ̂ݒu܂.
	 */
	public RecordSet SQL_Query(String sql, String... args) {

		// SQL̕u 
		Object[] objs = args;
		return SQL_Query((args != null) ? SQLUtil.parseAndReplace(sql, Arrays.asList(objs)) : null, sql);
	}
	
	private RecordSet SQL_Query(final SQLUtil.Parsed parsedSQL, String sql) {
		
		String query = (parsedSQL == null) ? sql : parsedSQL.query;

		return SQL_Query(query, new SQLQueryCall() {
			public ResultSet impl(PreparedStatement stmt) throws SQLException {

				// SQLzXgϐ̒u
				for (int i = 0; parsedSQL != null
						&& parsedSQL.parameter != null
						&& i < parsedSQL.parameter.size(); i++) {
					stmt.setObject(i + 1, parsedSQL.parameter.get(i));
				}
				return stmt.executeQuery();
			}
		});
	}

	public RecordSet SQL_Query(String sql, SQLQueryCall caller) {
		PreparedStatement stmt = null;
		ResultSet rs = null;
		try {

			log.fine("SQL: " + sql);

			stmt = this.getTrxContext().conn().prepareStatement(sql);
			rs = caller.impl(stmt);

			RecordSet record = new RecordSet();
			String[] columns = null;

			for (int i = 0; rs.next(); i++) {
				if (i == 0) {
					ResultSetMetaData meta = rs.getMetaData();
					columns = new String[meta.getColumnCount() + 1]; // columns[0] ̓_~[

					for (int col = 1; col < columns.length; col++) {
						columns[col] = meta.getColumnLabel(col).toLowerCase();
					}
				}

				for (int col = 1; col < columns.length; col++) {
					// f[^Zbg
					record.add(columns[col], i, rs.getObject(col));
				}
			}
			return record;
		} catch (SQLException ex) {
			throw new SystemException("f[^x[X֘Ȁł̃G[Lb`܂B", ex);
		} finally {
			try {
				if (rs != null)
					rs.close();
				if (stmt != null)
					stmt.close();
			} catch (SQLException ex) {
				throw new SystemException("f[^x[X֘Ȁł̃G[Lb`܂B", ex);
			}
		}
	}

	/**
	 * SELECT ̃p[^Aۂ̒lŒuԂ܂.
	 * fobOp\bh
	 * 
	 * @param sql String SQL 
	 * @return p[^u
	 */
	public String SQL_Trace(String sql) {
		return SQL_Trace(sql, (Map<String,Object>) null);
	}

	public String SQL_Trace(String sql, RecordSet params) {
		return SQL_Trace(sql, DBConnect.friendCaller.getMap(params));
	}

	public String SQL_Trace(String sql, RecordSet params, int index) {
		return SQL_Trace(sql, DBConnect.friendCaller.getMap(params), index);
	}

	public String SQL_Trace(String sql, Map<String,Object> params) {
		return SQL_Trace(sql, params, -1);
	}

	public String SQL_Trace(String sql, Map<String,Object> params, int index) {

		// SQL̕u
		return SQL_Trace((params != null) ? SQLUtil.parseAndReplace(sql, params, index) : null, sql);	
	}
	
	public String SQL_Trace(String sql, Object... args) {

		Object[] objs = args;

		// SQL̕u
		return SQL_Trace((args != null) ? SQLUtil.parseAndReplace(sql, Arrays.asList(objs)) : null, sql);	
	}
	
	private String SQL_Trace(final SQLUtil.Parsed parsedSQL, String sql) {
		
		// uȂꍇ
		if (parsedSQL == null || parsedSQL.parameter == null) return sql;
		
		// SQLzXgϐ̒u
		sql = parsedSQL.query;
		for (int i = 0; i < parsedSQL.parameter.size(); i++) {
			sql = sql.replaceFirst("\\?", parsedSQL.parameter.get(i).toString());
		}
		return sql;
	}
	
	protected final void closeConnection() {

		if (this.getTrxContext().isDBChanged()) {
			try {
				log.warning("[WARNING] R~bg̕ύX܂̂ŁA[obN܂.");
				this.getTrxContext().conn().rollback();
			} catch (SQLException sqlex) {
				log.log(Level.SEVERE, "gUNV[obNł܂ł.", sqlex);
			}
		}
		try {
			// RlNVmĂ΃N[Y
			if (this.getTrxContext().isOpenConnection())
				this.getTrxContext().conn().close();
		} catch (SQLException sqlex) {
			throw new SystemException("RlNVN[Ył܂ł.", sqlex);
		}
		// f[^ύXtOuύXȂv
		this.getTrxContext().DB_NotChanged();		
	}
	
	public void commit() {
		try {
			this.getTrxContext().conn().commit();
		} catch (SQLException ex) {
			throw new SystemException("gUNVR~bgł܂ł.", ex);
		}
		// f[^ύXtOuύXȂv
		this.getTrxContext().DB_NotChanged();
	}

	public void rollback() {
		try {
			this.getTrxContext().conn().rollback();
		} catch (SQLException ex) {
			throw new SystemException("gUNV[obNł܂ł.", ex);
		}
		// f[^ύXtOuύXȂv
		this.getTrxContext().DB_NotChanged();
	}
}
