package jp.botiboti.flextyle.core;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import jp.botiboti.flextyle.util.DateTime;

/**
 * s~Ńf[^ێNX.
 * ͗񖼁ijŎw肵As͍sԍijŎw肵܂.
 *
 * @author tanaka ken
 */
public class RecordSet {

  /**
   * Interface of Inner Iterator for RecordSet. 
   */
  public static interface Itr {
    Object process(Object val);
  }
  /**
   * Interface of Inner Iterator for RecordSet.
   * this iterator callbacked with index count. 
   */
  public static interface ItrIndex {
    Object process(Object tgtVal, int index);
  }

  /**
   * Define allowed class to Access to getMap() method.
   * this definition is used to be called Friend-Class.
   */
  public static class RecordSetFriend {
  	private static final String[] allowed = {
  		"jp.botiboti.flextyle.core.DBConnect",
  		"jp.botiboti.flextyle.core.LogicBase",
  		"jp.botiboti.flextyle.web.RecordSetForJSP"
  	};  	
  	protected RecordSetFriend() {
  		String className = this.getClass().getName();
  		for (String allowedClassName: allowed)
  			if (className.startsWith(allowedClassName)) return;
  		
  		throw new RuntimeException(className + "is not allowed to access");
  	}
  	public Map<String,Object> getMap(RecordSet rs) {
  		return rs.getMap();
  	}
  }
  
  private Map<String,Object> master_ = new HashMap<String,Object>();

  public RecordSet() {
  }

  public RecordSet(RecordSet rs) {
    this.master_.putAll(rs.master_);
  }

  public RecordSet(Map<String,? extends Object> map) {
    Iterator<String> itr = map.keySet().iterator();
    while (itr.hasNext()) {
      String key = (String)itr.next();
      Object obj = map.get(key);
      if (obj != null && obj.getClass().isArray()) {
        obj = new ArrayList<Object>(Arrays.asList((Object[])obj));
      }
      master_.put(key, obj);
    }
  }

  // setter ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  @SuppressWarnings("unchecked")
  public void add(String key, Object value) {
    Object obj = master_.get(key);
    if (obj != null && obj instanceof List)
      ((List<Object>)obj).add(value);
    else if (obj != null)
      add(key, 1, value);
    else
      set(key, value);
  }

  public void add(String key, int index, Object value) {
    if (getCount(key) == 0 && index == 0)
      set(key, value);
    else
      getList(key).add(index, value);
  }

  public void set(String key, int index, Object value) {
    if (getCount(key) <= 1 && index == 0)
      set(key, value);
    else if (index == getCount(key))
      getList(key).add(value);
    else
      getList(key).set(index, value);
  }

  public void set(String key, Object value) {
    master_.put(key, value);
  }

  public void addAll(RecordSet rs) {
    this.master_.putAll(rs.master_);
  }

  public void copy(String fromCol, String toCol) {
    for (int i = 0; i < getCount(fromCol); i++)
	  	set(toCol, i, get(fromCol, i));
  }

  // remove ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  public void clearAll() {
    this.master_.clear();
  }

  public Object remove(String col) {
    return this.master_.remove(col);
  }

  public Object remove(String col, int index) {
    Object obj = master_.get(col);
    if (obj != null && obj instanceof List) {
      return ((List<?>)obj).remove(index);
    }
    else if (index == 0) {
      return remove(col);
    }
    return null;
  }

  public void rename(String fromCol, String toCol) {
    copy(fromCol, toCol);
    remove(fromCol);
  }

  // getter ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  public Object getObject(String key) {
    return get(key);
  }

  public String getString(String key) {
    Object obj = get(key);
    return obj == null? null: obj instanceof String ? (String)obj: obj.toString();
  }

  public BigDecimal getBigDecimal(String key) {
    return (BigDecimal)get(key);
  }

  public Integer getInt(String key) {
    return (Integer)get(key);
  }

  public Long getLong(String key) {
    return (Long)get(key);
  }

  public Number getNumber(String key) {
    return (Number)get(key);
  }

  public Timestamp getTimestamp(String key) {
    return (Timestamp)get(key);
  }

  public DateTime getDateTime(String key) {
  	Object obj = get(key);
    return obj == null ? null: obj instanceof DateTime ? (DateTime)obj: new DateTime((Date)obj);  
  }

  public String getString(String key, int index) {
    return (String)get(key, index);
  }

  public BigDecimal getBigDecimal(String key, int index) {
    return (BigDecimal)get(key, index);
  }

  public Integer getInt(String key, int index) {
    return (Integer)get(key, index);
  }

  public Long getLong(String key, int index) {
    return (Long)get(key, index);
  }

  public Number getNumber(String key, int index) {
    return (Number)get(key, index);
  }

  public Timestamp getTimestamp(String key, int index) {
    return (Timestamp)get(key, index);
  }

  public DateTime getDateTime(String key, int index) {
  	Object obj = get(key, index);
    return obj == null ? null: obj instanceof DateTime ? (DateTime)obj: new DateTime((Date)obj);  
  }

  /**
   * @param key J
   * @return w肳ꂽJ́Al݂̂XgɓĕԂ܂.
   */
  public List<? extends Object> getListValues(String key) {
    return getList(key); // key ݂ȂꍇÃXgԂ.
  }

  public boolean isEmpty() {
    return master_.isEmpty();
  }

  public boolean isNotEmpty() {
    return !isEmpty();
  }

  /** private method to allow access by Friend.
   */
  private Map<String,Object> getMap() {
    return new HashMap<String,Object>(this.master_);
  }

  public Set<String> keySet() {
    return this.master_.keySet();
  }

  /**
   * ̂QAL[ƒl̃yAƂ}bvԂ܂. ̑ɂA
   * keyCol̒l񖼂ɂȂAvalCol̒lꂼ̒lƂȂ܂B@
   * Ȃ킿AkeyColɏdlꍇ́ALƂȂ܂.
   * @param keyCol String L[ƂĎw肷J
   * @param valCol String lƂĎw肷J
   * @return Map keyCol̒lL[AvalCol̒llƂ}bv
   */
  public Map<String,Object> getKeyAndVal(String keyCol, String valCol) {
    Map<String,Object> result = new HashMap<String,Object>();
    for (int i = 0, max = getCount(keyCol); i < max; i++) {
    	Object key = get(keyCol, i);
      result.put(key instanceof String? (String)key: key.toString(), get(valCol, i));
    }
    return result;
  }

  /** @param refCol
   *  @param refVal
   *  @return if value exists as get(refCol, i) == refVal, return true, otherwise false. 
   */
  public boolean contains(String refCol, Object refVal) {
    return findIndex(refCol, refVal) >= 0;
  }

  /**
   * ɏ]AR[h̃CfbNX擾܂. <br />
   *  "J=l",܂"J<>l"Ƃ`̕Ŏw肵ĂB
   * Ⴆ΁A
   * [ L ]ƂJÂ悤Ȓlݒ肳ĂꍇA<br>
   * [ "A" ]<br>
   * [ "K" ]<br>
   * [ "Q" ]<br>
   * findRowIndex("L=K") ƂĂяo 1 擾邱Ƃł܂.
   * @param condition String B"J=l",܂"J<>l"Ƃ`Ŏw肵ĂB
   * @return Object R[h̃CfbNXAłȂꍇ -1 Ԃ܂.
   */
  public int findIndex(String condition) {
  	String[] colAndVal = condition.indexOf('=') >= 0? condition.split("=", 2): condition.split("<>", 2);
  	if (colAndVal == null || colAndVal.length != 2) return -1;
  	return findIndex(colAndVal[0], colAndVal[1], condition.indexOf('=') >= 0);
  }

  public int findIndex(String refCol, Object refVal) {
    return this.findIndex(refCol, refVal, true);
  }

  /**
   * ɏ]AvfĎ擾܂. <br />
   *  "J=l",܂"J<>l"Ƃ`̕Ŏw肵ĂB
   * Ⴆ΁A
   * [ L,     ]Ƃ̃JÂ悤Ȓlݒ肳ĂꍇA<br>
   * [ "A", "G[X" ]<br>
   * [ "K", "LO" ]<br>
   * [ "Q", "NC"]<br>
   * find("", "L=K") ƂĂяo "LO" 擾邱Ƃł܂.
   * @param tgtCol String 擾J
   * @param condition String B"J=l",܂"J<>l"Ƃ`Ŏw肵ĂB
   * @return Object lAłȂꍇ null Ԃ܂.
   */
  public Object find(String tgtCol, String condition) {
	int i = findIndex(condition);
    return (i >= 0)? get(tgtCol, i): null;
  }

  private int findIndex(String refCol, Object refVal, boolean equal) {
    for (int i = 0, max = getCount(refCol); i < max; i++) {
    	if (equal && refVal.equals(get(refCol, i))) return i;
    	if (!equal && !refVal.equals(get(refCol, i))) return i;
    }
    return -1;
  }

  /** Flag to Specify output format of JSON.
   */
  public enum JsonMode {
  	
  	/** output array format, if element count is 1.
  	 *  this flag should be used for list of data.
  	 *  ex, { key: [ "val" ] }
  	 */
  	OutputArray,
  	
  	/** output key and value format, if element count is 1.
  	 *  ex, { key: "val" }
  	 */
  	OutputSingleValue,
  	
  	/** output json data with no line-feed.
  	 *  ex, { key1: "val", key2: "val" } 
  	 */
  	NoLineFeed,
  	
  	/** output json data with line-feed.
  	 *  ex, <br/>{<br/>@key1: "val",<br/>@key2: "val"<br/>}
  	 */
  	WithLineFeed, 
  };
  
  /** @return  
   */
  public String toJSON() {
  	return toJSON(JsonMode.OutputSingleValue, JsonMode.WithLineFeed);
  }
  
  /** @param mode JsonMode to specify output mode.   
   *  @return JSON Formatted String of contained this RecordSet.
   */
  public String toJSON(JsonMode... mode) {
  	
  	boolean lineFeed = true, outputArray = false;
  	for (JsonMode m: mode) {
  		if (m == JsonMode.NoLineFeed)
  			lineFeed = false;
  		if (m == JsonMode.OutputArray)
  			outputArray = true;
  	}
  	return toJSON(lineFeed, outputArray);
  }
  
  private String toJSON(boolean lineFeed, boolean outputArray) {
  	StringBuffer buf = new StringBuffer();
  	
  	buf.append("{");
  	if (lineFeed) buf.append("\n\t");
  	
  	Iterator<String> itr = master_.keySet().iterator();
  	for (String key; itr.hasNext() && (key = itr.next()) != null;) {
  		
  		// z̏ꍇ
  		if (this.getCount(key) > 1 || outputArray) {
  			buf.append("\"").append(key).append("\"").append(": [");
  			for (int i = 0, max = this.getCount(key); i < max; i++) {
  				if (i > 0) buf.append(",");
  				toJSONString(buf, this.get(key, i));
  			}
  			buf.append("]");
  		}
  		// złȂꍇ
  		else {
  			buf.append("\"").append(key).append("\"").append(": ");
  			toJSONString(buf, this.get(key));
  		}
  		// s 
  		if (itr.hasNext()) buf.append(",");
  		if (lineFeed) buf.append("\n");
  	}
  	// IuWFNg
  	return buf.append("}").toString();
  }
  
  // Cӂ̃IuWFNgAJSON̕\ƂāAStringBufferɏ݂܂
  private static void toJSONString(StringBuffer buf, Object obj) {
  	if (obj == null)
  		buf.append("null");
  	
  	else if (obj instanceof Boolean)
  		buf.append(obj.toString());
  	
  	else if (obj instanceof Number)
  		buf.append(obj.toString());
  	
  	else if (obj instanceof List) {
  		buf.append("[ ");
  		for (int i = 0; i < ((List<?>)obj).size(); i++) {
  			if (i > 0) buf.append(", ");
  			toJSONString(buf, ((List<?>)obj).get(i));
  		}
  		buf.append(" ]");
  	}
  	else if (obj instanceof Map) {
  		buf.append("{ ");
  		Iterator<?> itr = ((Map<?,?>)obj).keySet().iterator();
  		for (Object key; itr.hasNext() && (key = itr.next()) != null; ) {
  			buf.append("\"").append(key).append("\"").append(": ");
  			toJSONString(buf, ((Map<?,?>)obj).get(key));
  			if (itr.hasNext()) buf.append(", ");
  		}
  		buf.append(" }");
  	}
  	else {
  		// s"GXP[v
  		String str = obj.toString().replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r").replace("\"", "\\\"").replace("\'", "\\\'");
  		buf.append("\"").append(str).append("\"");
  	}
  }
  
  public RecordSet subSet(int startRow, int recordCount) {
  	
		RecordSet result = new RecordSet();
  	  Iterator<String> itr = master_.keySet().iterator();
    
		while (itr.hasNext()) {
		 	String key = itr.next();
	  	for (int i = 0, max = this.getCount(key); i < max; i++) {
			if ((i+1) < startRow || (i+1) >= startRow + recordCount)
			  continue;
			result.add(key, this.get(key, i));
	  	}
		}
		return result; 
  }

  // iterator ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  /**
   * apply Iterator specified by Parameter [itr] to Column of key.
   * @param tgtCol column name 
   * @param itr iterator
   */
  public void iterate(String key, Itr itr) {
    for (int i = 0, max = getCount(key); i < max; i++) {
      set(key, i, itr.process(get(key, i)));
    }
  }

  /**
   * Apply Iterator specified by Parameter [itr] to key.
   * this method is synonym of iterate()
   */
  public void apply(String key, Itr itr) {
  	this.iterate(key, itr);
  }

  /**
   * apply Iterator specified by Parameter [itr] to Column of tgtCol.
   * @param tgtCol column name 
   * @param itr iterator
   */
  public void iterate(String tgtCol, ItrIndex itr) {
    for (int i = 0, max = getCount(tgtCol); i < max; i++) {
    	set(tgtCol, i, itr.process(get(tgtCol, i), i));
    }
  }

  /**
   * Apply Iterator specified by Parameter [itr] to tgtCol.
   * this method is synonym of iterate()
   */
  public void apply(String tgtCol, ItrIndex itr) {
  	this.iterate(tgtCol, itr);
  }

  public void applyToMatched(String tgtCol, final Itr itr, String condition) {
  	this.applyToMatched(tgtCol, new ItrIndex() {
  		public Object process(Object obj, int index) {
  			return itr.process(obj);
  		}
  	}, condition);
  }
  
  public void applyToMatched(String tgtCol, ItrIndex itr, String condition) {
  	String[] colAndVal = condition.indexOf('=') >= 0? condition.split("=", 2): condition.split("<>", 2);
  	if (colAndVal == null || colAndVal.length != 2) return;

  	boolean equal = condition.indexOf('=') >= 0;
  	boolean notEqual = !equal;
  	
  	for (int i = 0, max = getCount(tgtCol); i < max; i++) {
  		if (notEqual && this.get(colAndVal[0], i).equals(colAndVal[1]))
  			continue;
  		if (equal && !this.get(colAndVal[0], i).equals(colAndVal[1]))
  			continue;
  		
  		set(tgtCol, i, itr.process(get(tgtCol, i), i));
  	}
  }
  
  public void copyWith(String fromCol, String toCol, Itr itr) {
  	for (int i = 0, max = getCount(fromCol); i < max; i++) {
    	set(toCol, i, itr.process(get(fromCol, i)));
    }
  }
  
  public void copyWith(String fromCol, String toCol, ItrIndex itr) {
    for (int i = 0, max = getCount(fromCol); i < max; i++) {
    	set(toCol, i, itr.process(get(fromCol, i), i));
    }
  }

  // implement method ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


  /**
   * @return element count of key. 
   */
  public int getCount(String key) {
    if (master_.containsKey(key) == false) return 0;
    Object obj = master_.get(key);
    return (obj instanceof List)? ((List<?>)obj).size(): 1;
  }

  /**
   * @return element count of any key of contained.
   */
  public int getCount() {
  	Iterator<String> itr = master_.keySet().iterator();
  	return itr.hasNext()? getCount(itr.next()): 0;
  }

  public Object get(String key, int index) {
    if (index == 0) {
      Object obj = master_.get(key);
      if (obj == null || ! (obj instanceof List)) {
        return obj;
      }
    }
    return getList(key).get(index);
  }


  public Object get(String key) {
    Object obj = master_.get(key);
    if (obj != null && obj instanceof List) {
      List<?> list = (List<?>)obj;
      return (list.isEmpty())? null: list.get(0);
    }
    return obj;
  } 
  
  public List<Map<String,Object>> toList(String baseColName) {	
		List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
	  
		for (int i = 0, max = getCount(baseColName); i < max; i++) {
	  
		  Map<String,Object> row = new HashMap<String,Object>();
		  Iterator<String> itr = master_.keySet().iterator();
	  
	  	for (String key; itr.hasNext() && (key = itr.next()) != null; ) {
				if (this.getCount(key) > i)
	      	row.put(key, this.get(key, i));
		  }
		  result.add(row);
		}
		return result;
  }
  
  public List<Map<String,Object>> toSortedList(final String baseColName) {
  
  	List<Map<String,Object>> result = this.toList(baseColName);
  
  	Collections.sort(result, new Comparator<Map<String,Object>>() {
  		@SuppressWarnings("unchecked")
  		public int compare(Map<String,Object> p1, Map<String,Object> p2) {
  			
  			if (p1==null || p1.get(baseColName)==null || !(p1.get(baseColName) instanceof Comparable<?>)) return -1;
  			if (p2==null || p2.get(baseColName)==null || !(p2.get(baseColName) instanceof Comparable<?>)) return 1;

  			return ((Comparable<? super Object>)p1.get(baseColName)).compareTo(p2.get(baseColName));
  		}
  	});
  	
  	return result;
  }
  
  public List<Map<String,Object>> toSortedList(final String baseColName, final Comparator<? super Object> cmptr) {	
		
  	List<Map<String,Object>> result = this.toList(baseColName);
		
  	Collections.sort(result, new Comparator<Map<String,Object>>() {
  		public int compare(Map<String,Object> p1, Map<String,Object> p2) {
  			return cmptr.compare(p1==null? null:p1.get(baseColName), p2==null? null:p2.get(baseColName));
  		}
  	});
		
		return result;
  }
  
  // private method ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  
  @SuppressWarnings("unchecked")
  private List<Object> getList(String key) {
    Object obj = master_.get(key);
    if (obj != null && obj instanceof List<?>) {
      return (List<Object>)obj;
    }
    List<Object> list = new ArrayList<Object>();
    if (master_.containsKey(key)) {
      list.add(obj);
    }
    master_.put(key, list);
    return list;
  }

  // debug method ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  public String toString() {
    StringBuffer buf = new StringBuffer();

    Iterator<String> itr = master_.keySet().iterator();
    while (itr.hasNext()) {
      String key = itr.next();
      for (int i = 0, max = getCount(key); i < max; i++) {
        buf.append(key).append("[").append(i).append("]: ");
        buf.append(get(key, i)).append("\n");
      }
    }
    return buf.toString();
  }

}
