package jp.botiboti.flextyle.extension;

import java.util.Properties;

import jp.botiboti.flextyle.core.ConnectionFactory;
import jp.botiboti.flextyle.util.Util;

import org.apache.tomcat.dbcp.dbcp.cpdsadapter.DriverAdapterCPDS;
import org.apache.tomcat.dbcp.dbcp.datasources.SharedPoolDataSource;

public class ConnectionFactoryForTomcat extends ConnectionFactory {

  protected static void initialize(Properties prop) {
  	
  	String driverName = prop.getProperty("driverClass");//"com.mysql.jdbc.Driver";
  	
  	try {
  		DriverAdapterCPDS cpds = new DriverAdapterCPDS();
  		cpds.setDriver(driverName);
  		cpds.setUrl(prop.getProperty("url")); //"jdbc:mysql://192.168.24.240/chiniwa?useUnicode=true&amp;characterEncoding=utf8"
  		cpds.setUser(prop.getProperty("user")); // "chiniwa_user"
  		cpds.setPassword(prop.getProperty("password")); // "chiniwa_user_password"
  		
  		SharedPoolDataSource tds = new SharedPoolDataSource();
  		tds.setConnectionPoolDataSource(cpds);
  		
  		if (Util.isNotNullOrBlank(prop.getProperty("maxActive")) && Util.isNumber(prop.getProperty("maxActive")))
  			tds.setMaxActive(Integer.parseInt(prop.getProperty("maxActive")));

  		if (Util.isNotNullOrBlank(prop.getProperty("maxWait")) && Util.isNumber(prop.getProperty("maxWait")))
  			tds.setMaxWait(Integer.parseInt(prop.getProperty("maxWait")));
  		
  		initialize(tds);
  	}
    catch (ClassNotFoundException exp) {
    	System.out.println("JDBC Driver[" + driverName + "] is not found.");
    }
  }
}
