package jp.botiboti.flextyle.jsf;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.botiboti.flextyle.util.Log;

/**
 * Ajax̌ĂяofBXpb`邽߂̃T[ubgNX
 *
 */
public class AjaxDispatchServletStudy extends javax.servlet.http.HttpServlet implements javax.servlet.Servlet {
   	
	private static final long serialVersionUID = -5398320268550932900L;
	private static final Logger log = new Log.LoggerFriend() { }.fxt();
	
	private String errorPrefix = "ERROR";	
	private String packageNameOfBeanClass = "jp.botiboti.undone.flextyle.beans";
	
	public void init(ServletConfig arg0) throws ServletException {
		
		String str1 = arg0.getInitParameter("ERROR_PREFIX");		
		String str2 = arg0.getInitParameter("PACKAGE_NAME_OF_BEAN_CLASS");
		
		if (str1 != null && !str1.equals("")) this.errorPrefix = str1;
		if (str2 != null && !str2.equals("")) this.packageNameOfBeanClass = str2;
	}

	protected void doGet(HttpServletRequest request, HttpServletResponse response) 
		throws ServletException, IOException {
		this.doPostOrGet(request, response);
	}  	
	
	protected void doPost(HttpServletRequest request, HttpServletResponse response) 
		throws ServletException, IOException {
		this.doPostOrGet(request, response);
	}
	
	@SuppressWarnings("unchecked")
	private void doPostOrGet(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException {

		Map<String, Object> requestMap = new HashMap<String, Object>();
		Map<String, Object> sessionMap = new HashMap<String, Object>();

		// ZbV̏}bvɃRs[
		Enumeration<?> enumer = request.getSession().getAttributeNames();
		while (enumer.hasMoreElements()) {
			String key = (String)enumer.nextElement();
			sessionMap.put(key, request.getSession().getAttribute(key));			
		}

		// ReLXg쐬
		Context ctx = new Context(
				(Map<String,String[]>)request.getParameterMap(),
				requestMap, sessionMap);

		// LbVȂ
		response.setHeader("Pragma","no-cache");
		response.setHeader("Cache-Control","no-cache");
		response.setDateHeader("Expires",0);
		
		// rWlXWbŇĂяo //
		String pathInfo = request.getPathInfo();
		String[] args = pathInfo.split("\\.");
		Object retValue = null;
		
		if (pathInfo.contains(".") == false 
			|| args.length != 2 
			|| args[0].startsWith("/") == false) {
			
			retValue = errorPrefix + ": tqk̎w肪ԈĂ܂B[" + pathInfo + "]";
		}
		else {
			try {
				// pbP[W
				String pkgName = request.getParameter("packageNameOfBeanClass");
				if (pkgName == null || pkgName.equals("")) pkgName = this.packageNameOfBeanClass;
				
				// "/"菜
				args[0] = args[0].substring(1);

				// BeanNX̓ǂݍ
				Class<?> beanClass = Class.forName(packageNameOfBeanClass + "." + args[0]);
				// BeanCX^X쐬
				Object beanObj = beanClass.newInstance();

// ̃NX@\ɂ͂̌ĂяoKvA܂͂API͍폜Ă				
//				// BeanɃReLXgZbg
//				((BaseBean)beanObj).setContext(ctx);

				// rWlX\bhĂяo
				retValue = beanClass.getMethod(args[1], new Class[0]).invoke(beanObj, new Object[0]);
			}
			catch (Exception e) {
				retValue = errorPrefix + ": " + e.toString();
				log.log(Level.WARNING, errorPrefix + ": " + e.toString(), e);
			}
		}
		// rWlXWbNI // 

		// gUNV̏I
		ctx.finalizeContext();

		// AJAXX|X̏o
		response.setCharacterEncoding("UTF-8");
		response.setContentType("text/plain; charset=UTF-8");
		response.getWriter().write(retValue.toString());		

		// ZbV}bv̏ZbVɃRs[
		enumer = request.getSession().getAttributeNames();
		while (enumer.hasMoreElements()) {
			// ܂A폜
			request.getSession().removeAttribute((String)enumer.nextElement());			
		}
		// ZbVɃZbg
		Iterator<String> sesItr = sessionMap.keySet().iterator();
		for (String key; sesItr.hasNext() && (key = sesItr.next()) != null; ) {
			request.getSession().setAttribute(key, sessionMap.get(key));
		}		
	}
		
}