package jp.botiboti.flextyle.jsf;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.botiboti.flextyle.util.Log;

public class AjaxDispatcher {

	private static final Logger log = new Log.LoggerFriend() { }.fxt();
	private static final String ErrorPrefix = "ERROR";	
	
	private String getPackageNameOfBeanClass(HttpServletRequest request) {
		// pbP[W
		String pkgName = request.getParameter("packageNameOfBeanClass");
		if (pkgName != null && !pkgName.equals("")) return pkgName;
		
		log.fine("WARNING: AjaxDispatcher;\n"
			+ "pbP[Ww肳܂ł̂ŁAftHg̃pbP[WKp܂.");
		
		return "jp.botiboti.undone.flextyle.beans"; 
	}
	
	private String getBeanAndMethodName(HttpServletRequest request) {
		String name = request.getParameter("beanAndMethodName");
		if (name == null || name.indexOf(".") == -1) {
			return null;
		}
		return name;
	}
	
	public void dispatch(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException {
	
		// LbVȂ
		response.setHeader("Pragma","no-cache");
		response.setHeader("Cache-Control","no-cache");
		response.setDateHeader("Expires",0);
		
		// rWlXWbŇĂяo //
		Object retValue = null;
		String beanAndMethodName = getBeanAndMethodName(request);
		if (beanAndMethodName == null) {			
			retValue = ErrorPrefix + ": tqk̎w肪ԈĂ܂B[" + request.getRequestURI() + request.getQueryString() + "]";
		}
		else {
			try {
				// NXƃ\bhɕ 
				String[] args = beanAndMethodName.split("\\.", 2);
	
				// BeanNX̓ǂݍ
				Class<?> beanClass = Class.forName(getPackageNameOfBeanClass(request) + "." + args[0]);
				// BeanCX^X쐬
				Object beanObj = beanClass.newInstance();
	
				// rWlX\bhĂяo
				retValue = beanClass.getMethod(args[1], new Class[0]).invoke(beanObj, new Object[0]);
			}
			catch (Exception e) {
				retValue = ErrorPrefix + ": " + e.toString();
				log.log(Level.WARNING, ErrorPrefix + ": " + e.toString(), e);				
			}
		}
		// rWlXWbNI // 
	
		// AJAXX|X̏o
		response.setCharacterEncoding("UTF-8");
		response.setContentType("text/plain; charset=UTF-8");
		response.getWriter().write(retValue.toString());
	}
}