package jp.botiboti.flextyle.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateTime extends Timestamp {

	private static final long serialVersionUID = -1226885865005125752L;

	public DateTime() {
		super(System.currentTimeMillis());
	}
	
	public DateTime(Date t) {
		super(t.getTime());
	}
	
	public DateTime(long l) {
		super(l);
	}

	public DateTime(Calendar cal) {
		super(cal.getTime().getTime());
	}

	// any...
	
	public static DateTime today() {
		return new DateTime(DateUtil.today());
	}
	
	public static DateTime now() {
		return new DateTime(DateUtil.now());
	}
	
	public static DateTime parse(String src, String format) {
		try {
			return new DateTime(new SimpleDateFormat(format).parse(src));
		}
		catch (ParseException exp) {
			throw new IllegalArgumentException("Date format [" + format + "] is invalid for " + src + ".");
		}
	}
	
	public static DateTime parseYYYYMMDD(String src) {
		return parse(src, "yyyyMMdd");
	}
	
	public static DateTime parseYYYYMM(String src) {
		return parse(src, "yyyyMM");
	}
	
	/**
	 * @return DateTimeIuWFNg̎ԕNAAtɂ܂
	 */
	public DateTime clearTime() {		
		return new DateTime(resetTime(this.cal()));
	}
	
	public DateTime beforeNHour(int n) {
		return this.afterNHour(n * -1);
	}

	public DateTime afterNHour(int n) {
		Calendar cal = this.cal();
    cal.add(Calendar.HOUR_OF_DAY, n);
    return new DateTime(cal);
	}

	/**
   * j킷lԂ.l̒`́Ajava.util.Calendar NX̂Ƃł.
   * @return int j킷l
   */
  public int dayOfWeek() {
    Calendar cal = Calendar.getInstance();
    cal.setTime(this);
    return cal.get(Calendar.DAY_OF_WEEK);
  }

  /**
   * O킷 DateTime IuWFNgԂ.
   */
  public DateTime prevDay(DateTime date) {
  	Calendar cal = this.cal();
    cal.add(Calendar.DATE, -1);
    return new DateTime(cal);
  }

  /**
   * 킷 DateTime IuWFNgԂ.
   */
  public DateTime nextDay() {
    Calendar cal = this.cal();
    cal.add(Calendar.DATE, 1);
    return new DateTime(cal);
  }

  /**
   * 	NO킷 DateTime IuWFNgԂ.
   */
  public DateTime beforeNDay(int n) {
    Calendar cal = this.cal();
    cal.add(Calendar.DATE, -n);
    return new DateTime(cal);
  }

  /**
   * N킷 DateTime IuWFNgԂ.
   */
  public DateTime afterNDay(int n) {
    Calendar cal = this.cal();
    cal.add(Calendar.DATE, n);
    return new DateTime(cal);
  }

  /**
   * 1O킷 DateTime IuWFNgԂ.
   * beforeNMonth(1) Ɠ`ł.
   */
  public DateTime prevMonth() {
    return this.beforeNMonth(1);
  }

  /**
   * 1킷 DateTime IuWFNgԂ.
   * afterNMonth(1)Ɠ`ł.
   */
  public DateTime nextMonth() {
    return this.afterNMonth(1);
  }

  /**
   * NO킷 DateTime IuWFNgԂ.
   */
  public DateTime beforeNMonth(int n) {
    Calendar cal = this.cal();
    cal.add(Calendar.MONTH, -n);
    return new DateTime(cal);
  }

  /**
   * N킷 DateTime IuWFNgԂ.
   */
  public DateTime afterNMonth(int n) {
    Calendar cal = this.cal();
    cal.add(Calendar.MONTH, n);
    return new DateTime(cal);
  }

  /**
   * NNO̓t쐬ĕԂ.
   */
  public DateTime beforeNYear(int n) {
    Calendar cal = this.cal();
    cal.add(Calendar.YEAR, -n);
    return new DateTime(cal);
  }

  /**
   * NN̓t쐬ĕԂ.
   */
  public DateTime afterNYear(int n) {
    Calendar cal = this.cal();
    cal.add(Calendar.YEAR, n);
    return new DateTime(cal);
  }

  /**
   * Nxw肵āA4/1 ̓tԂ.
   */
  public static DateTime firstOfYearCycle(Integer year) {
    Calendar cal = Calendar.getInstance();
    cal.clear();
    cal.set(year.intValue(), Calendar.APRIL, 1);
    resetTime(cal);
    return new DateTime(cal);
  }

  /**
   * Nxw肵āA3/31 ̓tԂ.
   */
  public static DateTime lastOfYearCycle(Integer year) {
    Calendar cal = Calendar.getInstance();
    cal.clear();
    cal.set(year.intValue() +1, Calendar.MARCH, 31);
    resetTime(cal);
    return new DateTime(cal);
  }

  /**
   * ̔Nx 4/1 ̓tԂ.
   */
  public DateTime firstOfYearCycle() {

    Calendar cal = this.cal();
    int year = cal.get(Calendar.YEAR);
    int month = cal.get(Calendar.MONTH);
    if (month < 3) {
      year--;
    }
    cal.set(year, Calendar.APRIL, 1);
    resetTime(cal);
    return new DateTime(cal);
  }
  
  /**
   * ̔Nx 3/31 ̓tԂ.
   */
  public DateTime lastOfYearCycle() {

    Calendar cal = this.cal();
    int year = cal.get(Calendar.YEAR);
    int month = cal.get(Calendar.MONTH);
    if (month < 3) {
      year--;
    }
    cal.set(year+1, Calendar.MARCH, 31);
    resetTime(cal);
    return new DateTime(cal);
  }
  
  /**
   *@Nx\ Integer Ԃ.
   */
  public Integer yearCycle() {
    Calendar cal = this.cal();
    int year = cal.get(Calendar.YEAR);
    int month = cal.get(Calendar.MONTH);
    if (month < 3) {
      year--;
    }
    return new Integer(year);
  }

  /**
   * 擾.
   */
  public DateTime firstOfMonth() {
    Calendar cal = this.cal();
    cal.set(Calendar.DATE, 1);
    return new DateTime(cal);
  }

  /**
   * 擾.
   */
  public DateTime lastOfMonth() {
    Calendar cal = this.cal();
    cal.set(Calendar.DATE, 1);
    // P
    cal.add(Calendar.MONTH, 1);
    cal.add(Calendar.DATE, -1);
    return new DateTime(cal);
  }

  /**
   * 擾.
   */
  public DateTime firstOfNextMonth() {
    Calendar cal = this.cal();
    cal.set(Calendar.DATE, 1);
    cal.add(Calendar.MONTH, 1);
    return new DateTime(cal);
  }

  /**
   * O擾.
   */
  public DateTime firstOfPrevMonth() {
    Calendar cal = this.cal();
    cal.set(Calendar.DATE, 1);
    cal.add(Calendar.MONTH, -1);
    return new DateTime(cal);
  }

  /**
   * @return ̓\ǂԂ.
   */
  public boolean isFirstOfMonth() {
  	return this.getTime() == this.firstOfMonth().getTime();
  }
  
  /**
   * @return ̓\ǂԂ.
   */
  public boolean isLastOfMonth(DateTime date) {
  	return this.getTime() == this.lastOfMonth().getTime();
  }

  /**
   * @return NijԂ.
   */
  public int getYear() {
  	Calendar cal = this.cal();
  	return cal.get(Calendar.YEAR);
  }
  
  /**
   * @return i0-11jԂ. 
   */
  public int getMonth() {
  	Calendar cal = this.cal();
  	return cal.get(Calendar.MONTH);
  }

  /**
   * @return i1-31jԂ. 
   */
  public int getDate() {
  	Calendar cal = this.cal();
  	return cal.get(Calendar.DAY_OF_MONTH);
  }
  
  /**
   * @return YYYYMMDD`̕ƂĕԂ܂.
   */
  public String toYYYYMMDD() {
    Calendar cal = this.cal();
    int year = cal.get(Calendar.YEAR);
    int month = cal.get(Calendar.MONTH) + 1;
    int dt = cal.get(Calendar.DATE);
    return String.valueOf(year*10000 + month*100 + dt);
  }

  /**
   * @return YYYYMM`̕ƂĕԂ܂. 
   */
  public String toYYYYMM() {
  	Calendar cal = this.cal();
    int year = cal.get(Calendar.YEAR);
    int month = cal.get(Calendar.MONTH) + 1;
    return String.valueOf(year*100 + month);
  }

  /**
   * @return YYYY`̕ƂĕԂ܂.
   */
  public String toYYYY() {
    Calendar cal = this.cal();
    return String.valueOf(cal.get(Calendar.YEAR));
  }
  
  /**
   * @return DD`̕ƂĕԂ܂.
   */
  public String toDD() {
    return String.valueOf(getDate());
  }
  
  /**
   * @return YYYY/MM/DD`̕ƂĕԂ܂.
   */
  public String toYYYYMMDDf() {
  	return this.toYYYYMMDDf("/");
  }

  /**
   * @param delim N̋؂蕶
   * @return YYYY[؂蕶]MM[؂蕶]DD `̕ƂĕԂ܂.
   */
  public String toYYYYMMDDf(String delim) {

    Calendar cal = this.cal();
    int year = cal.get(Calendar.YEAR);
    int month = cal.get(Calendar.MONTH) + 1;
    int dt = cal.get(Calendar.DATE);
    return String.valueOf(year*10000 + delim + month*100 + delim + dt);
  }

  /**
   * @return YYYY/MM`̕ƂĕԂ܂.
   */
  public String toYYYYMMf() {
  	return this.toYYYYMMf("/");
  }

  /**
   * @param delim N̋؂蕶
   * @return YYYY[؂蕶]MM `̕ƂĕԂ܂.
   */
  public String toYYYYMMf(String delim) {

    Calendar cal = this.cal();
    int year = cal.get(Calendar.YEAR);
    int month = cal.get(Calendar.MONTH) + 1;
    String month_ = String.valueOf(month);
    if (month < 10) {
    	month_ = "0" + month_;
    }

    return String.valueOf(year + delim + month_);
  }
  
  /**
   * @return HH:MM `̕ƂĕԂ܂.
   */
  public String toHHMMf() {

    return this.toHHMMf(":");
  }
  
  /**
   * @param delim Ԃ̋؂蕶
   * @return HH[؂蕶]MM `̕ƂĕԂ܂.
   */
  public String toHHMMf(String delim) {

    Calendar cal = this.cal();
    int hour = cal.get(Calendar.HOUR_OF_DAY);
    int minute = cal.get(Calendar.MINUTE);
    
    StringBuffer buf = new StringBuffer(); 
    
    (hour < 10 ? buf.append("0"): buf).append(hour);
    buf.append(delim);
    (minute < 10 ? buf.append("0"): buf).append(minute);
    
    return buf.toString();
  }
  
  // ** private methods ****************************

  /**
   * ̃IuWFNg̕ێ鎞̃J_[IuWFNg擾܂.
   * ߂l̃J_[IuWFNg̎ԕ͂OŏĂ܂.
   * @return Calendar J_[IuWFNg
   */
  private Calendar cal() {
    Calendar cal = Calendar.getInstance();
    cal.setTime(this);
    return cal;
  }

  // J_[NXt݂̂ɂȂ悤ɃZbg.
  private static Calendar resetTime(Calendar cal) {
    cal.set(Calendar.HOUR_OF_DAY, 0);
    cal.set(Calendar.MINUTE, 0);
    cal.set(Calendar.SECOND, 0);
    cal.set(Calendar.MILLISECOND, 0);
    return cal;
  }
}
