package jp.botiboti.flextyle.util;

import java.util.Enumeration;
import java.util.Iterator;

/**
 * EnumerationNXIterable̋@\ǉ
 * 
 * @author ktanaka
 */
public class IterableEnumeration<T> implements Iterable<T>, Enumeration<T> {

	private Enumeration<T> enumer;
	
	@SuppressWarnings("unchecked")
	public IterableEnumeration(Enumeration<?> base) {
		this.enumer = (Enumeration<T>)base;
	}
	
	public boolean hasMoreElements() {
		return this.enumer.hasMoreElements();
	}
	
	public T nextElement() {
		return this.enumer.nextElement();
	}
	
	public Iterator<T> iterator() {
		return new Iterator<T>() {
			public boolean hasNext() {
				return enumer.hasMoreElements();
			}
			public T next() {
				return enumer.nextElement();
			}			
			public void remove() {
				throw new UnsupportedOperationException();
			}
		};
	}

}
