package jp.botiboti.flextyle.util;

import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Oo͗pNX.
 * @author tanaka ken
 */
public class Log {

	/**
	 * ̃NXŕێQ̃K[i"flextyle.framework","flextyle.application"j̐eƂȂ郍K[IuWFNgiK[F"flextyle"j
	 */
	protected static final Logger parent = Logger.getLogger("flextyle"); 
	
	/**
	 * t[[NŎgp郍K[IuWFNgiK[F"flextyle.framework"j
	 */
	protected static final Logger fxt = Logger.getLogger("flextyle.framework");

	/**
	 * [UAvP[VŎgp鎖z肵K[IuWFNgiK[F"flextyle.application"j
	 */
	public static final Logger app = Logger.getLogger("flextyle.application");
	
	static {
		initialize();
	}
	
	private static void initialize() {
		
		if ( (fxt.getHandlers() != null && fxt.getHandlers().length > 0)  ||
				 (app.getHandlers() != null && app.getHandlers().length > 0) )
			return;
		
		try {
			File f = new File("./logs");
			if (!f.exists())
				f.mkdir();
			
			Handler fHandler = new FileHandler("./logs/flextyle.%u.log", true);
			fHandler.setLevel(Level.INFO);
			fHandler.setFormatter(new LogFormatter());
			
			Handler cHandler = new ConsoleHandler();
			cHandler.setLevel(Level.FINE);
			cHandler.setFormatter(new LogFormatter());
			
			parent.addHandler(fHandler);
			parent.addHandler(cHandler);
			parent.setUseParentHandlers(false);
			parent.setLevel(Level.FINE);
		}
		catch (IOException ex) {
			System.out.println("[Fetal] K[̏ɃG[܂Bȍ~AOo͂Ȃ\܂.");
			ex.printStackTrace(System.out);
		}	
	}
	
	/**
	 * fxttB[hɃt[[NO̓ANZXȂ悤ɂ邽߂̃ubWNX 
	 */
	public static class LoggerFriend {
		
		private static final String allowed = "jp.botiboti.flextyle";
  	
		protected LoggerFriend() {
  		
			if (this.getClass().getName().startsWith(allowed))
  			return;
  		throw new RuntimeException(this.getClass().getName() + "is not allowed to access");
  	}
		
  	public Logger fxt() {
  		return fxt;
  	}
  }
	
}
