package jp.botiboti.flextyle.util;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

import jp.botiboti.flextyle.core.SystemException;

abstract public class ReflectionUtil<T> {

	abstract protected T impl() throws Exception;
	
	public interface ExceptionHandler<T> {
		T handle(Exception exp);
	}
	
	@SuppressWarnings("unchecked")
  static <H extends Throwable> void castThrow(Throwable t) throws H {
		throw (H)t;
	}
	
	private Map<Class<?>, ExceptionHandler<T>> map = null;
	
	public <E extends Exception> void addExceptionHandler(Class<E> cls, ExceptionHandler<T> handler) {
		if (this.map == null)
			this.map = new HashMap<Class<?>, ExceptionHandler<T>>();
		
		this.map.put(cls, handler);
	}
	
	public T createInstance() {
		try {
			try {
				return impl();
			}
			catch (Exception exp) {
				if (this.map != null && map.containsKey(exp.getClass()))
					return this.map.get(exp.getClass()).handle(exp);
				else
					throw exp;
			}
		}
		catch (IllegalAccessException ex) {
			throw new SystemException("w肳ꂽNXւ̌Ăяo͐Ă܂B", ex);
		}
		catch (ClassNotFoundException ex) {
			throw new SystemException("w肳ꂽNX[hł܂B", ex);
		}
		catch (InstantiationException ex) {
			throw new SystemException("w肳ꂽNX̃CX^X쐬ł܂B", ex);
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException("s̃G[܂B", ex);
		}
	}
	
	public T invokeMethod() {
		try {
			try {
				return impl();
			}
			catch (Exception exp) {
				if (this.map != null && this.map.containsKey(exp.getClass()))
					return this.map.get(exp.getClass()).handle(exp);
				else
					throw exp;
			}
		}
		catch (IllegalAccessException ex) {
			throw new SystemException("w肳ꂽ\bȟĂяo͐Ă܂B", ex); 
		}
		catch (InvocationTargetException ex) {
			throw new SystemException("rWlXWbNsɁAG[܂B", ex); 
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException("s̃G[܂B", ex);
		}
	}
}
