package jp.botiboti.flextyle.web;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.botiboti.flextyle.core.LogicCall;
import jp.botiboti.flextyle.core.SystemException;
import jp.botiboti.flextyle.util.Log;
import jp.botiboti.flextyle.util.ReflectionUtil;

public class Dispatcher {
	
	private static final Logger logger = new Log.LoggerFriend(){}.fxt();
	
	private static Dispatcher defaultInstance = null;	
  
  Dispatcher() {
  	if (defaultInstance == null) defaultInstance = this;
  }
  
	/**
	 * @return first created instance of Dispatcher 
	 */
  public static final Dispatcher defaultInstance() {	return defaultInstance;	}
  
	/**
	 * w肳ꂽWebBeanNX̃CX^X쐬܂.
	 * @param className WebBeanNX
	 * @return 쐬ꂽCX^X
	 */
	public WebBean createWebBean(final String className) {
		return new ReflectionUtil<WebBean>() {
				public WebBean impl() throws Exception {
					final Class<?> beanClass = Class.forName(className);
		
					if (WebBean.class.isAssignableFrom(beanClass) == false) {
						// WebBeanNX̃TuNXł͂Ȃꍇ
						throw new SystemException("w肳ꂽNX́AWebBeañTuNXł͂܂B" + className);
					}
					// WebBean ̃TuNX̃CX^X쐬
					return (WebBean)beanClass.newInstance();
				}
			}.createInstance();
	}
	
	/**
	 * w肳ꂽWebBean̊Y\bhĂяo܂.
	 * @param req NGXgIuWFNg
	 * @param res X|XIuWFNg
	 * @param bean WebBeanCX^X
	 * @param methodName \bh
	 * @param parameter \bhp[^
	 * @return WebBean̖߂l
	 */
	public Object dispatch(HttpServletRequest req, final HttpServletResponse res, 
			final WebBean bean, final String methodName, final List<String> parameter) {

		bean.setRequest(new RequestWrapper(req));
		
		// WebBeañ\bhĂяo
		Object result = bean.start(new LogicCall<Object>() {

			public Object impl() {
			
				try {
					ReflectionUtil<Object> ref = new ReflectionUtil<Object>() {
					
						public Object impl() throws Exception {
							for(Method method: bean.getClass().getMethods()) {
								
								if (method.getName().equals(methodName)) {
									Object[] p = new Object[method.getParameterTypes().length];				
									return method.invoke(bean, parameter == null ? p: parameter.toArray(p));
								}
							}
						  throw new SystemException("w肳ꂽ\bh[" + methodName + "]܂łB");
						}
					};
					ref.addExceptionHandler(InvocationTargetException.class, new ReflectionUtil.ExceptionHandler<Object>() {
						public Object handle(Exception ex) {
							logger.log(Level.SEVERE, "rWlXWbN̎sŏQ܂B", ex.getCause() != null? ex.getCause(): ex);
							return null;
						}
					});
					return ref.invokeMethod();
				}
				catch (RuntimeException ex) {
					logger.log(Level.SEVERE, "rWlXWbN̎sŏQ܂B", ex.getCause() != null? ex.getCause(): ex);
					return null;
				}
			}
				
		}, UserDataFactory.getUserData(req));
		
		return result;
	}
	
	/**
	 * NX.
	 */
	@SuppressWarnings("unchecked")
	private static class RequestWrapper extends WebBean.RequestWrapper {
		RequestWrapper(HttpServletRequest req) { this.request = req; }
		private HttpServletRequest request;
		public Map<String,Object> getAttributeMap() {			
			Map<String,Object> result = null;
			Enumeration<String> enu = this.request.getAttributeNames();
			for (String key = null; enu.hasMoreElements() && (key = enu.nextElement()) != null; ) {
				if (result == null) result = new HashMap<String,Object>();;
				result.put(key, this.request.getAttribute(key));
			}
			return result;
		}
		public Map<String,Object> getParameterMap() { return this.request.getParameterMap(); }
		public Object getAttribute(String arg0) { return this.request.getAttribute(arg0); }
		public String getHeader(String arg0) { return this.request.getHeader(arg0); }
		public Enumeration<String> getHeaders(String arg0) { return this.request.getHeaders(arg0); }
		public Enumeration<String> getHeaderNames() { return this.request.getHeaderNames(); }
		public String getMethod() { return this.request.getMethod(); }
		public int getContentLength() { return this.request.getContentLength(); }
		public String getContentType() { return this.request.getContentType(); }	
		public Reader getReader() throws IOException { return this.request.getReader(); }		
	}

}
