package jp.botiboti.flextyle.web;

import groovy.lang.GroovyClassLoader;

import java.io.File;
import java.io.IOException;

import jp.botiboti.flextyle.core.SystemException;
import jp.botiboti.flextyle.util.ReflectionUtil;

public class DispatcherWithGroovy extends Dispatcher {

	private String filePath;
	
	DispatcherWithGroovy(String groovyFilePath) {
		this.filePath = groovyFilePath;
	}
	
	public WebBean createWebBean(final String className) {
		return new ReflectionUtil<WebBean>() {
			public WebBean impl() throws Exception {
					
				Class<?> beanClass = null;
				try {
					beanClass = Class.forName(className);
				}
				catch (ClassNotFoundException ex) { 
					try {
						GroovyClassLoader loader = new GroovyClassLoader(this.getClass().getClassLoader());
						beanClass = loader.parseClass(new File(filePath + className.replace('.', '/').concat(".groovy")));
					}
					catch (IOException exp) {
						throw new SystemException("groovyt@Cǂݍ߂܂łB", exp);
					}
				}
				
				if (WebBean.class.isAssignableFrom(beanClass) == false) {
					// WebBeanNX̃TuNXł͂Ȃꍇ
					throw new SystemException("w肳ꂽNX́AWebBeañTuNXł͂܂B" + className);
				}
				// WebBean ̃TuNX̃CX^X쐬
				return (WebBean)beanClass.newInstance();
			}
		}.createInstance();
	}
	
}
