package jp.botiboti.flextyle.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletResponse;

import jp.botiboti.flextyle.util.Log;

public class WebErrorUtil {

	private static final Logger log = new Log.LoggerFriend() { }.fxt();
	
	// G[(HTML)o͂
	public static void writeErrorPage(HttpServletResponse res, String msg, Throwable ex) {
		res.setCharacterEncoding("UTF-8");
		res.setContentType("text/html; charset=UTF-8");
		
		PrintWriter writer; try {
			writer = res.getWriter();
		}
		catch (IOException ioEx) {
			log.log(Level.SEVERE, "G[ʍ쐬ɁAIOG[܂B", ioEx); return;
		}
		
		writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
		writer.println("<html><body>");
		writer.println("<p>Web Application Error.</p><hr />");
		writer.println(msg + "<hr />");
		
		if (ex != null) 
			do {
				ex.printStackTrace(writer);
				writer.print("<hr />");
			}
			while ((ex = ex.getCause()) != null);
		
		writer.println("</body></html>");		
		writer.close();
	}
	
}
