package jp.botiboti.flextyle.web.taglib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletRequest;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.VariableInfo;

import jp.botiboti.flextyle.util.IterableEnumeration;
import jp.botiboti.flextyle.util.Util;

/**
 * NGXgp[^AMap<String,String>vfƂ郊Xg(=List<Map<String,String>>)
 * ɕϊ^Ou. Xg̗vfkeyŎw肵lɂČ܂.
 * 
 * <fxt:parameterList var="listName" key="itemKey" />
 * 
 * @author tanaka ken
 */
public class ParameterListTag extends TagSupport {

	/** SerialNo */
	private static final long serialVersionUID = -3502776732332018379L;

	public static class TEI extends TagExtraInfo {
		public VariableInfo[] getVariableInfo(TagData tagData) {

			return new VariableInfo[] {
				new VariableInfo(tagData.getAttributeString("var"), 
					"java.util.List",	true, VariableInfo.AT_END)
			};
		}
	}
	
	/** var property */
	private String var;
	
	/** key property */	
	private String key;
	
	/** minSize property */
	private String minSize;
	
	public String getVar() {
		return var;
	}

	public void setVar(String var) {
		this.var = var;
	}

//	public String getSizeOf() {
//		return key;
//	}
//
//	public void setSizeOf(String sizeOf) {
//		this.key = sizeOf;
//	}
//	
	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}
	
	public String getMinSize() {
		return minSize;
	}

	public void setMinSize(String minSize) {
		this.minSize = minSize;
	}

	/** 
	 * ^OŎw肳ꂽeɏ]āAListIuWFNg쐬
	 */
	public int doStartTag() {
		
		ServletRequest req = pageContext.getRequest();
		
		List<Map<String,String>> pList = null;
		
		boolean minSizeIsSet = (this.minSize != null && Util.isNumber(this.minSize));
		boolean parameterExists = (req.getParameter(this.key) != null);
		
		if (minSizeIsSet || parameterExists) { 					
			pList = new ArrayList<Map<String,String>>();
		}
		else {
			return SKIP_BODY;
		}
		
		if (parameterExists) {
			
			Iterable<String> params = new IterableEnumeration<String>(req.getParameterNames());
	
			for (int i = 0, max = req.getParameterValues(this.key).length; i < max; i++) {
				
				pList.add(new HashMap<String,String>());
	
				for (String key: params) {
					String[] values = req.getParameterValues(key);
					
					if (values == null || i >= values.length )
						continue;
					else
						pList.get(i).put(key, values[i]);
				}
			}
		}
		if (pList.isEmpty()) {
			for (int i = 0, max = Integer.parseInt(this.minSize); i < max; i++) 
				pList.add(new HashMap<String,String>());
		}
		
		pageContext.setAttribute(this.var, pList);
		return SKIP_BODY;
		
	}
		
	public int doEndTag() {
		return EVAL_PAGE;
	}

}
