//---------------------------------------------------------------------------


#pragma hdrstop

#include "DropAcceptor.h"
#include "MainForm.h"
#include "Preferences.h"
#include <cassert>
#include <Atl/atlbase.h>

//---------------------------------------------------------------------------

#pragma package(smart_init)

void initialize_fe( FORMATETC* fe ) {
  fe->cfFormat = CF_TEXT;
  fe->dwAspect = DVASPECT_CONTENT;
  fe->ptd      = 0;
  fe->tymed    = TYMED_HGLOBAL;
  fe->lindex   = -1;
}

DropAcceptor::DropAcceptor( TMainFormUI* mainForm )
 : numRef_(0), mainForm_(mainForm) {
  OleInitialize(NULL);
}

void DropAcceptor::setupView() {
  HRESULT hr;

  /* register self for accept drag and drop */
  hr = RegisterDragDrop( mainForm_->Handle, this );
  assert( S_OK == hr || DRAGDROP_E_ALREADYREGISTERED == hr );
  //hr = RegisterDragDrop( mainForm_->View->Handle, this );
  //assert( S_OK == hr || DRAGDROP_E_ALREADYREGISTERED == hr );


}

void DropAcceptor::setupDocument() {
  mainForm_->View->RegisterAsDropTarget = true;
  mainForm_->View->RegisterAsDropTarget = false;

  CComQIPtr<ICustomDoc, &IID_ICustomDoc>
    customDoc( mainForm_->View->Document );
  //assert( false == (!customDoc) );
  if (!customDoc) {
    return;
  }

  HRESULT hr = customDoc->SetUIHandler( this );
  assert( SUCCEEDED(hr) );

}

HRESULT STDMETHODCALLTYPE
DropAcceptor::DragEnter
    ( IDataObject *pDataObj,
      DWORD grfKeyState,
      POINTL pt,
      DWORD *pdwEffect) {

  *pdwEffect = DROPEFFECT_MOVE;

  /*
   * a part of the code is based on one at following url:
   * http://community.borland.com/article/0,1410,26545,00.html
   */
  FORMATETC fe;
  STGMEDIUM stg;
  initialize_fe( &fe );
  HRESULT hr = pDataObj->GetData(&fe,&stg);
  assert( SUCCEEDED(hr) );

  if (SUCCEEDED(hr)) {
    const char* begin = (char *)GlobalLock(stg.hGlobal);
    word_ = std::string( begin, begin+ GlobalSize(stg.hGlobal) );
    GlobalUnlock(stg.hGlobal);
    ReleaseStgMedium(&stg);

    if (Preferences::instance().searchOnDragEnter()) {
      mainForm_->dropped( word_ );
    }//if
  }//if


  return S_OK;
}

HRESULT STDMETHODCALLTYPE
DropAcceptor::DragOver
    ( DWORD grfKeyState,
      POINTL pt,
      DWORD *pdwEffect) {
  return S_OK;
}

HRESULT STDMETHODCALLTYPE
DropAcceptor::DragLeave( void ) {
  return S_OK;
}

HRESULT STDMETHODCALLTYPE
DropAcceptor::Drop
    ( IDataObject *pDataObj,
      DWORD grfKeyState,
      POINTL pt,
      DWORD *pdwEffect) {

  mainForm_->dropped( word_ );
  return S_OK;
}

HRESULT STDMETHODCALLTYPE
DropAcceptor::GetHostInfo(struct _DOCHOSTUIINFO *host) {
  return E_NOTIMPL;
}

HRESULT STDMETHODCALLTYPE
DropAcceptor::ShowContextMenu
    ( DWORD dwID,
      POINT __RPC_FAR *ppt,
      IUnknown __RPC_FAR *pcmdReserved,
      IDispatch __RPC_FAR *pdispReserved) {
  return E_NOTIMPL;
}


HRESULT STDMETHODCALLTYPE
DropAcceptor::ShowUI
    ( DWORD dwID,
      IOleInPlaceActiveObject __RPC_FAR *pActiveObject,
      IOleCommandTarget __RPC_FAR *pCommandTarget,
      IOleInPlaceFrame __RPC_FAR *pFrame,
      IOleInPlaceUIWindow __RPC_FAR *pDoc ) {
  return E_NOTIMPL;
}

HRESULT STDMETHODCALLTYPE
DropAcceptor::HideUI(void) {
  return E_NOTIMPL;
}

HRESULT STDMETHODCALLTYPE
DropAcceptor::UpdateUI(void) {
  return E_NOTIMPL;
}

HRESULT STDMETHODCALLTYPE
DropAcceptor::EnableModeless( BOOL fEnable ) {
  return E_NOTIMPL;
}

HRESULT STDMETHODCALLTYPE
DropAcceptor::OnDocWindowActivate(BOOL fActivate ) {
  return E_NOTIMPL;
}

HRESULT STDMETHODCALLTYPE
DropAcceptor::OnFrameWindowActivate( BOOL fActivate ) {
  return E_NOTIMPL;
}

HRESULT STDMETHODCALLTYPE
DropAcceptor::ResizeBorder
    ( LPCRECT prcBorder,
      IOleInPlaceUIWindow __RPC_FAR *pUIWindow,
      BOOL fRameWindow ) {
  return E_NOTIMPL;
}

HRESULT STDMETHODCALLTYPE
DropAcceptor::TranslateAccelerator
    ( LPMSG lpMsg,
      const GUID __RPC_FAR *pguidCmdGroup,
      DWORD nCmdID ) {
  return E_NOTIMPL;
}

HRESULT STDMETHODCALLTYPE
DropAcceptor::GetOptionKeyPath
    ( LPOLESTR __RPC_FAR *pchKey,
      DWORD dw ) {
  return E_NOTIMPL;
}

HRESULT STDMETHODCALLTYPE
DropAcceptor::GetDropTarget
    ( IDropTarget __RPC_FAR *pDropTarget,
      IDropTarget __RPC_FAR *__RPC_FAR *ppDropTarget ) {
  //return E_NOTIMPL;
  *ppDropTarget = this;
  return S_OK;
}

HRESULT STDMETHODCALLTYPE
DropAcceptor::GetExternal
    ( IDispatch __RPC_FAR *__RPC_FAR *ppDispatch) {
  return E_NOTIMPL;
}

HRESULT STDMETHODCALLTYPE
DropAcceptor::TranslateUrl
    ( DWORD dwTranslate,
      OLECHAR __RPC_FAR *pchURLIn,
      OLECHAR __RPC_FAR *__RPC_FAR *ppchURLOut ) {
  return E_NOTIMPL;
}

HRESULT STDMETHODCALLTYPE
DropAcceptor::FilterDataObject
    ( IDataObject __RPC_FAR *pDO,
      IDataObject __RPC_FAR *__RPC_FAR *ppDORet ) {
  return E_NOTIMPL;
}

