//---------------------------------------------------------------------------

#ifndef DropAcceptorH
#define DropAcceptorH
//---------------------------------------------------------------------------

#include <oleidl.h>
#include <mshtmhst.h>
#include <string>

class TMainFormUI; /* forward decl */

class DropAcceptor : public IDropTarget, public IDocHostUIHandler {
public:
  DropAcceptor( TMainFormUI* mainForm );

  void setupView();
  void setupDocument();
  // interface IDropTarget
  virtual HRESULT STDMETHODCALLTYPE DragEnter
    ( IDataObject *pDataObj,
      DWORD grfKeyState,
      POINTL pt,
      DWORD *pdwEffect);
  virtual HRESULT STDMETHODCALLTYPE DragOver
    ( DWORD grfKeyState,
      POINTL pt,
      DWORD *pdwEffect);

  virtual HRESULT STDMETHODCALLTYPE DragLeave( void );

  virtual HRESULT STDMETHODCALLTYPE Drop
    ( IDataObject *pDataObj,
      DWORD grfKeyState,
      POINTL pt,
      DWORD *pdwEffect);

  //interface IDocHostUIHandler
  virtual HRESULT STDMETHODCALLTYPE GetHostInfo(struct _DOCHOSTUIINFO *host);

  virtual HRESULT STDMETHODCALLTYPE ShowContextMenu
    ( DWORD dwID,
      POINT __RPC_FAR *ppt,
      IUnknown __RPC_FAR *pcmdReserved,
      IDispatch __RPC_FAR *pdispReserved);


  virtual HRESULT STDMETHODCALLTYPE ShowUI
    ( DWORD dwID,
      IOleInPlaceActiveObject __RPC_FAR *pActiveObject,
      IOleCommandTarget __RPC_FAR *pCommandTarget,
      IOleInPlaceFrame __RPC_FAR *pFrame,
      IOleInPlaceUIWindow __RPC_FAR *pDoc );

  virtual HRESULT STDMETHODCALLTYPE HideUI(void);

  virtual HRESULT STDMETHODCALLTYPE UpdateUI(void);

  virtual HRESULT STDMETHODCALLTYPE EnableModeless( BOOL fEnable);

  virtual HRESULT STDMETHODCALLTYPE OnDocWindowActivate(BOOL fActivate);

  virtual HRESULT STDMETHODCALLTYPE OnFrameWindowActivate( BOOL fActivate);

  virtual HRESULT STDMETHODCALLTYPE ResizeBorder
    ( LPCRECT prcBorder,
      IOleInPlaceUIWindow __RPC_FAR *pUIWindow,
      BOOL fRameWindow );

  virtual HRESULT STDMETHODCALLTYPE TranslateAccelerator
    ( LPMSG lpMsg,
      const GUID __RPC_FAR *pguidCmdGroup,
      DWORD nCmdID );

  virtual HRESULT STDMETHODCALLTYPE GetOptionKeyPath
    ( LPOLESTR __RPC_FAR *pchKey,
      DWORD dw );

  virtual HRESULT STDMETHODCALLTYPE GetDropTarget
    ( IDropTarget __RPC_FAR *pDropTarget,
      IDropTarget __RPC_FAR *__RPC_FAR *ppDropTarget );

  virtual HRESULT STDMETHODCALLTYPE GetExternal
    ( IDispatch __RPC_FAR *__RPC_FAR *ppDispatch);

  virtual HRESULT STDMETHODCALLTYPE TranslateUrl
    ( DWORD dwTranslate,
      OLECHAR __RPC_FAR *pchURLIn,
      OLECHAR __RPC_FAR *__RPC_FAR *ppchURLOut );

  virtual HRESULT STDMETHODCALLTYPE FilterDataObject
    ( IDataObject __RPC_FAR *pDO,
      IDataObject __RPC_FAR *__RPC_FAR *ppDORet );

  // Interface IUnknown
  virtual HRESULT STDMETHODCALLTYPE QueryInterface
    (REFIID iid, void ** ppvObject) {
    if(0 == ppvObject) { return E_POINTER; }

    if(IID_IUnknown    == iid ||
       IID_IDropTarget == iid) {
      *ppvObject = (void *)this;
      AddRef();
      return NOERROR;
    }//if

    return E_NOINTERFACE;
  }

  virtual ULONG STDMETHODCALLTYPE AddRef(void) {
    return (++numRef_);
  }

  virtual ULONG STDMETHODCALLTYPE Release(void) {
    --numRef_;

    if (0 == numRef_) {
      /* write cleanup code here */
    }//if

    return numRef_;
  }

private:
  int numRef_;
  std::string word_;
  TMainFormUI* mainForm_;
};

#endif
