//---------------------------------------------------------------------------

#ifndef PreferencesH
#define PreferencesH
//---------------------------------------------------------------------------
#include "Site.h"
#include <vcl/inifiles.hpp>
#include <boost/scoped_ptr.hpp>
#include <boost/utility.hpp>
//---------------------------------------------------------------------------

class Preferences : boost::noncopyable {
public:
  SiteList* sites() const { return sites_.get(); }
  bool readClipboard() const { return readClipboard_; }
  bool searchOnFocus() const { return searchOnFocus_; }
  bool searchOnDragEnter() const { return searchOnDragEnter_; }
  bool callScript() const { return callScript_; }
  int  historyLimit() const { return historyLimit_; }
  int  windowWidth()  const { return windowWidth_;  }
  int  windowHeight() const { return windowHeight_; }
  void readClipboard( bool value );
  void searchOnFocus( bool value );
  void searchOnDragEnter( bool value );
  void callScript( bool value );
  void  windowWidth( int value );
  void  windowHeight( int value );

  static Preferences & instance();
private:
  Preferences();
  SiteList* readSites();
  const Site readSite( int index );

  boost::scoped_ptr<TIniFile> inifile_;
  boost::scoped_ptr<SiteList> sites_;
  bool readClipboard_;
  bool searchOnFocus_;
  bool searchOnDragEnter_;
  bool callScript_;
  int  historyLimit_;
  int  windowWidth_;
  int  windowHeight_;
};

#endif
