//---------------------------------------------------------------------------


#pragma hdrstop

#include "Script.h"
#include <cassert>
#include <boost/lexical_cast.hpp>

#define SCRIPT_ENGINE_NAME    L"JavaScript"
#define DOCUMENT_OBJECT_NAME  L"document"

//---------------------------------------------------------------------------

void ScriptRunner::invoke( const ScriptString & code, IDispatch* doc ) {
  document_ = doc;

  CLSID clsid;
  HRESULT hr;

  //  Create Script Engine
  hr = CLSIDFromProgID( SCRIPT_ENGINE_NAME, &clsid );
  assert(SUCCEEDED(hr));
  IActiveScript* pe;
  hr = CoCreateInstance
    ( clsid, 0, CLSCTX_ALL, IID_IActiveScript, (void**)&pe );
  CComPtr<IActiveScript> engine( pe );
  assert( SUCCEEDED(hr) );

  //  Fetch Parser Interface
  CComQIPtr<IActiveScriptParse, &IID_IActiveScriptParse> parser(engine);
  assert( !(!parser) );
  parser->InitNew();

  //  Initialize Script Engine
  hr = engine->SetScriptSite( this );
  assert( SUCCEEDED(hr) );

  hr = engine->AddNamedItem
    ( DOCUMENT_OBJECT_NAME, SCRIPTITEM_GLOBALMEMBERS | SCRIPTITEM_ISVISIBLE  );
  assert( SUCCEEDED(hr) );
  hr = engine->SetScriptState( SCRIPTSTATE_STARTED  );
  assert( SUCCEEDED(hr) );
  hr = engine->SetScriptState( SCRIPTSTATE_CONNECTED  );
  assert( SUCCEEDED(hr) );
  hr = parser->ParseScriptText( code.c_str(), 0, 0, 0, 0, 0, 0, 0, 0 );
  assert( SUCCEEDED(hr) );
  //TODO: do not assert

  hr = engine->Close();
  assert( SUCCEEDED(hr) );

}

HRESULT STDMETHODCALLTYPE
ScriptRunner::GetItemInfo
  ( LPCOLESTR pstrName,     // address of item name
    DWORD dwReturnMask,     // bit mask for information retrieval
    IUnknown **ppunkItem,   // address of pointer to item's IUnknown
    ITypeInfo **ppTypeInfo  /* address of pointer to item's ITypeInfo */ ) {
    //TODO: impl;
  if ((dwReturnMask & SCRIPTINFO_IUNKNOWN) &&
      (ScriptString(pstrName) == DOCUMENT_OBJECT_NAME) ) {
    *ppunkItem = document_;
    return S_OK;
  }

  return TYPE_E_ELEMENTNOTFOUND;
}

HRESULT STDMETHODCALLTYPE
ScriptRunner::OnScriptError
    ( IActiveScriptError *error  /* address of error interface */) {
  DWORD context;
  ULONG line;
  LONG  pos;
  HRESULT hr;
  hr = error->GetSourcePosition( &context, &line, &pos );
  assert( SUCCEEDED(hr) );

  std::wstring desc( L"SCRIPT ERROR At line:" );
  std::string lineStr = boost::lexical_cast<std::string>(line);
  desc.append( lineStr.begin(), lineStr.end() );
  std::string posStr = boost::lexical_cast<std::string>(pos);
  desc += L", pos:";
  desc.append( posStr.begin(), posStr.end() );
  MessageBoxW( 0, desc.c_str(), L"SCRIPT ERROR", MB_OK );

      return S_OK;
  }


#pragma package(smart_init)
