//---------------------------------------------------------------------------

#ifndef ScriptH
#define ScriptH
//---------------------------------------------------------------------------

#include "Site.h"
#include <windows.h>
#include <ole2.h>
#include <initguid.h>
#include <activscp.h>
#include <Atl/atlbase.h>

class ScriptRunner : public IActiveScriptSite {
public:
  ScriptRunner() {}
  void invoke( const ScriptString & code, IDispatch* doc );
public:
  // Interface IUnknown
  virtual HRESULT STDMETHODCALLTYPE QueryInterface
    (REFIID iid, void ** ppvObject) {
    if(0 == ppvObject) { return E_POINTER; }

    if(IID_IUnknown    == iid ||
       IID_IDropTarget == iid) {
      *ppvObject = (void *)this;
      AddRef();
      return NOERROR;
    }//if

    return E_NOINTERFACE;
  }

  virtual ULONG STDMETHODCALLTYPE AddRef(void) {
    return (++numRef_);
  }

  virtual ULONG STDMETHODCALLTYPE Release(void) {
    --numRef_;

    if (0 == numRef_) {
      /* write cleanup code here */
    }//if

    return numRef_;
  }

//interface IActiveScriptSite
  HRESULT STDMETHODCALLTYPE GetLCID(LCID*) { return E_NOTIMPL; }
  HRESULT STDMETHODCALLTYPE GetItemInfo
    ( LPCOLESTR pstrName,     // address of item name
      DWORD dwReturnMask,     // bit mask for information retrieval
      IUnknown **ppunkItem,   // address of pointer to item's IUnknown
      ITypeInfo **ppTypeInfo  /* address of pointer to item's ITypeInfo */ );

  HRESULT STDMETHODCALLTYPE GetDocVersionString
    ( BSTR *pbstrVersionString  /* address of document version string */ ) {
      *pbstrVersionString = SysAllocString(L"1.0");
      return S_OK;
  }

  HRESULT STDMETHODCALLTYPE OnScriptTerminate
    ( const VARIANT *pvarResult,
      const EXCEPINFO *pexcepinfo ) {
      return S_OK;
  }

  HRESULT STDMETHODCALLTYPE OnStateChange
    ( SCRIPTSTATE ssScriptState  /* new state of engine */ ) {
      return S_OK;
  }

  HRESULT STDMETHODCALLTYPE OnScriptError
    ( IActiveScriptError *pase  /* address of error interface */);

  HRESULT STDMETHODCALLTYPE OnEnterScript(void) {
    return S_OK;
  }

  HRESULT STDMETHODCALLTYPE OnLeaveScript(void) {
      return S_OK;
  }

private:
  int numRef_;
  CComPtr<IDispatch> document_;
};//ScriptRunner

//---------------------------------------------------------------------------
#endif
